#if !defined(AFX_MYVIDEOWND_H__D556E902_0A66_4F20_9242_E07FA96F921F__INCLUDED_)
#define AFX_MYVIDEOWND_H__D556E902_0A66_4F20_9242_E07FA96F921F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define CLIPBOARD_FORMAT(lpszFormat) (::RegisterClipboardFormat(lpszFormat))

template<class T1, class T2> void ASSIGN_DATA(T1& n1, T2& n2, BOOL bDirection)
{
	if (bDirection == TRUE)
		n1 = n2;
	else
		n2 = n1;
}

template<class T> void SWAP(T& n1, T& n2)
{
	T t;
	t = n1;
	n1 = n2;
	n2 = t;
}

template <class T1> void COPY(T1* pDesc, T1* pSrc, int nCount)
{
	for (int i = 0; i < nCount; ++i) { pDesc[i] = pSrc[i];}
}

template<class T1> class WndDropTarget : public COleDropTarget
{
public:

	virtual DROPEFFECT OnDragEnter(CWnd* pWnd, COleDataObject* pDataObject, DWORD dwKeyState, CPoint point)
	{
		if (pWnd->IsKindOf(RUNTIME_CLASS(CWnd)))
		{
			ASSERT(m_hWnd != NULL);		// Did you forget to call Register?
			return ((T1*) pWnd)->OnDragEnter(pDataObject, dwKeyState, point);
		}
		return DROPEFFECT_NONE;
	}

	virtual DROPEFFECT OnDragOver(CWnd* pWnd, COleDataObject* pDataObject, DWORD dwKeyState, CPoint point)
	{
		if (pWnd->IsKindOf(RUNTIME_CLASS(CWnd)))
		{
			ASSERT(m_hWnd != NULL);		// Did you forget to call Register?
			return ((T1*) pWnd)->OnDragOver(pDataObject, dwKeyState, point);
		}
		return DROPEFFECT_NONE;
	}

	virtual void OnDragLeave( CWnd* pWnd )
	{
		if (pWnd->IsKindOf(RUNTIME_CLASS(CWnd)))
		{
			ASSERT(m_hWnd != NULL);		// Did you forget to call Register?
			((T1*) pWnd)->OnDragLeave();
		}
	}

	virtual BOOL OnDrop(CWnd* pWnd, COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point)
	{
		// BUG: If we didn't pass a FORMATETC pointer, GetGlobalData would
		// have created identical to the one below except the last variable
		// would by TYMED_HGLOBAL | TYMED_MFPICT. For some reason, if you
		// use GetGlobalData in response to data dropped from a selection
		// in a Windows 95 help file, the call will fail. If you remove
		// the TYMED_MFPICT option, the call is successful. It might be 
		// an OLE bug.
		if (pWnd->IsKindOf(RUNTIME_CLASS(CWnd)))
		{
			ASSERT(m_hWnd != NULL);		// Did you forget to call Register?
			return ((T1*) pWnd)->OnDrop(pDataObject, dropEffect, point);
		}
		return FALSE;
	}
};

class MyViewManager;
class MyLiveAV;
class MySwitchLiveAV;
class MyFileAV;
class MyLayout;

class CSecurity_DemoDlg;
 
class MyVideoWnd : public CWnd
{
	DECLARE_DYNAMIC(MyVideoWnd)
// Construction
public:
	MyVideoWnd();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(MyVideoWnd)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:

	void SetViewManager(MyViewManager *pMgr);	

	virtual DROPEFFECT OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);

	virtual DROPEFFECT OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);

	virtual BOOL OnDrop(COleDataObject *pDataObject, DROPEFFECT dropEffect, CPoint point);

	virtual void OnDragLeave();

	virtual ~MyVideoWnd();

	// Generated message map functions
protected:
	//{{AFX_MSG(MyVideoWnd)
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnClose();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnDestroy();
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);	
	afx_msg void OnPaint();
	afx_msg void OnWindowPosChanged( WINDOWPOS* lpwndpos );
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:

	int			m_nWndID;

	BOOL		m_bFullScreen;

	PVOID		m_pCustomChannelWindow;	

	ULONG		m_nSubChannelNumber;

	BOOL		m_bConnectVideo;

	CString     m_strShowText;

	MyLiveAV	*m_pLiveAV;

	MySwitchLiveAV	*m_pSwitchLiveAV;

	CSecurity_DemoDlg * m_pParentDlg;

	void DrawText(HDC hDC, int nX, int nY, CString strText, COLORREF clrColor);

	void SetLiveAV(MyLiveAV *pYLiveAV) { m_pLiveAV = pYLiveAV; }

	void SetSwitchLiveAV(MySwitchLiveAV *pSwitchLiveAV) { m_pSwitchLiveAV = pSwitchLiveAV; }		

private:	

	WndDropTarget<MyVideoWnd>*   m_pDropTarget;

	COleDataSource		m_DataSource;

    MyViewManager		*m_pViewManager;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MYVIDEOWND_H__D556E902_0A66_4F20_9242_E07FA96F921F__INCLUDED_)
