// SC3B0Dlg.h : header file
//

#if !defined(AFX_SC3B0DLG_H__5DBDB124_2FA4_4FA2_A7FA_1298C0C11B63__INCLUDED_)
#define AFX_SC3B0DLG_H__5DBDB124_2FA4_4FA2_A7FA_1298C0C11B63__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ChannelWindow.h"
#include "PropertyDlg.h"

typedef struct tagQcap
{
	CChannelWindow		m_oChannelWindows2;	
	PVOID 				m_hVideoDevice;
	ULONG				m_nVideoWidth;
	ULONG				m_nVideoHeight;
	BOOL				m_bVideoIsInterleaved;
	double				m_dVideoFrameRate;	
	BOOL				m_bNoSignal;
	BOOL				m_bVideoDeinterlaceEnable;
	BOOL				m_bHorizontalMirror;
	BOOL				m_bVerticalMirror;

	tagQcap():			m_hVideoDevice( 0 ),
						m_nVideoWidth( 0 ),
						m_nVideoHeight( 0 ),
						m_bVideoIsInterleaved( 0 ),
						m_dVideoFrameRate( 0.0 ),
						m_bNoSignal( 0 ),
						m_bVideoDeinterlaceEnable( 0 ),
						m_bHorizontalMirror( 0 ),
						m_bVerticalMirror( 0 )
	{
//		m_strShareFormatChangedOutput.Format( "CH%02d:%dX%d@%d FPS, %dCH@%dBITS x %dHZ", 1, 1920, 1080, 60, 2, 16, 48000 ); 
	}

} STRUCT_QCAP, PSTRUCT_QCAP;

typedef struct tagSetupRecordPropertyEx
{
	int			nResult;
	CHAR 		pszRecordFilePathName[ MAX_PATH ];

	ULONG		nEncoderType;
	ULONG		nEncoderFormat;
	ULONG		nRecordProfile;
	ULONG		nRecordLevel;
	ULONG		nRecordEntropy;
	ULONG		nRecordComplexity;
	ULONG		nRecordMode;
	ULONG		nQuality;
	ULONG		nBitRate;
	ULONG		nGOP;
	ULONG		nBFrames;
	BOOL		bIsInterleaved;
	ULONG		nAspectRatioX;
	ULONG		nAspectRatioY;
	ULONG		nCropX;
	ULONG		nCropY;
	ULONG		nCropW;
	ULONG		nCropH;
	ULONG		nDstW;
	ULONG		nDstH;

	ULONG		nPostSkipFrameRate;
	ULONG		nPostAvgFrameRate;
	ULONG		nPostFrameRateStatus;

	ULONG		nFileSplittingSize;		// KB
	ULONG		nFileSplittingTime;		// SEC
	ULONG		nFileSplittingStatus;

	ULONG		nRecordScale;
//
//	SUB PARAMETERS
//
	ULONG		nEncoderType2;
	ULONG		nEncoderFormat2;
	ULONG		nRecordProfile2;
	ULONG		nRecordLevel2;
	ULONG		nRecordEntropy2;
	ULONG		nRecordComplexity2;
	ULONG		nRecordMode2;
	ULONG		nQuality2;
	ULONG		nBitRate2;
	ULONG		nGOP2;
	ULONG		nBFrames2;
	BOOL		bIsInterleaved2;
	ULONG		nAspectRatioX2;
	ULONG		nAspectRatioY2;
	ULONG		nCropX2;
	ULONG		nCropY2;
	ULONG		nCropW2;
	ULONG		nCropH2;
	ULONG		nDstW2;
	ULONG		nDstH2;

	ULONG		nPostSkipFrameRate2;
	ULONG		nPostAvgFrameRate2;
	ULONG		nPostFrameRateStatus2;

	ULONG		nFileSplittingSize2;		// KB
	ULONG		nFileSplittingTime2;		// SEC
	ULONG		nFileSplittingStatus2;

	ULONG		nRecordScale2;
	
	tagSetupRecordPropertyEx()
	{
		lstrcpy(pszRecordFilePathName, "C:\\DEMO.MP4" );
		nResult						= IDOK;

		nEncoderType				= 0;				// (0)QCAP_ENCODER_TYPE_SOFTWARE(1)QCAP_ENCODER_TYPE_HARDWARE(2)QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK(3)QCAP_ENCODER_TYPE_AMD_STREAM(4)QCAP_ENCODER_TYPE_NVIDIA_CUDA(5)QCAP_ENCODER_TYPE_NVIDIA_NVENC
		nEncoderFormat				= 0;				// (0)QCAP_ENCODER_FORMAT_H264(1)QCAP_ENCODER_FORMAT_MPEG2(2)QCAP_ENCODER_FORMAT_H264_3D
		nRecordProfile				= 0;				// (0)QCAP_RECORD_PROFILE_BASELINE(1)QCAP_RECORD_PROFILE_MAIN(2)QCAP_RECORD_PROFILE_HIGH
		nRecordLevel				= 41;				// (0)QCAP_RECORD_LEVEL_1(41)QCAP_RECORD_LEVEL_41,...(52)QCAP_RECORD_LEVEL_52...
		nRecordEntropy				= 0;				// (0)QCAP_RECORD_ENTROPY_CAVLC(1)QCAP_RECORD_ENTROPY_CABAC
		nRecordComplexity			= 0;				// (0)QCAP_RECORD_COMPLEXITY_0~(6)QCAP_RECORD_COMPLEXITY_6
		nRecordMode					= 1;				// (0)QCAP_RECORD_MODE_VBR(1)QCAP_RECORD_MODE_CBR(2)QCAP_RECORD_MODE_ABR
		nQuality					= 8000;
		nBitRate					= 4000000;
		nGOP						= 30;
		nBFrames					= 0;
		bIsInterleaved				= 0;
		nAspectRatioX				= 0;
		nAspectRatioY				= 0;
		nCropX						= 0;
		nCropY						= 0;
		nCropW						= 0;
		nCropH						= 0;
		nDstW						= 0;
		nDstH						= 0;
		nPostSkipFrameRate			= 0;
		nPostAvgFrameRate			= 30;
		nPostFrameRateStatus		= 0;

		nFileSplittingSize			= 0;	// MB
		nFileSplittingTime			= 0;	// SEC
		nFileSplittingStatus		= 0;

		nRecordScale				= 0;
//
//	SUB
//
		nEncoderType2				= 0;				// (0)QCAP_ENCODER_TYPE_SOFTWARE(1)QCAP_ENCODER_TYPE_HARDWARE(2)QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK(3)QCAP_ENCODER_TYPE_AMD_STREAM(4)QCAP_ENCODER_TYPE_NVIDIA_CUDA(5)QCAP_ENCODER_TYPE_NVIDIA_NVENC
		nEncoderFormat2				= 0;				// (0)QCAP_ENCODER_FORMAT_H264(1)QCAP_ENCODER_FORMAT_MPEG2(2)QCAP_ENCODER_FORMAT_H264_3D
		nRecordProfile2				= 1;				// (0)QCAP_RECORD_PROFILE_BASELINE(1)QCAP_RECORD_PROFILE_MAIN(2)QCAP_RECORD_PROFILE_HIGH
		nRecordLevel2				= 41;				// (0)QCAP_RECORD_LEVEL_1(41)QCAP_RECORD_LEVEL_41,...(52)QCAP_RECORD_LEVEL_52...
		nRecordEntropy2				= 0;				// (0)QCAP_RECORD_ENTROPY_CAVLC(1)QCAP_RECORD_ENTROPY_CABAC
		nRecordComplexity2			= 0;				// (0)QCAP_RECORD_COMPLEXITY_0~(6)QCAP_RECORD_COMPLEXITY_6
		nRecordMode2				= 1;				// (0)QCAP_RECORD_MODE_VBR(1)QCAP_RECORD_MODE_CBR(2)QCAP_RECORD_MODE_ABR
		nQuality2					= 8000;
		nBitRate2					= 2000000;
		nGOP2						= 30;
		nBFrames2					= 0;
		bIsInterleaved2				= 0;
		nAspectRatioX2				= 0;
		nAspectRatioY2				= 0;
		nCropX2						= 0;
		nCropY2						= 0;
		nCropW2						= 0;
		nCropH2						= 0;
		nDstW2						= 0;
		nDstH2						= 0;
		nPostSkipFrameRate2			= 0;
		nPostAvgFrameRate2			= 30;
		nPostFrameRateStatus2		= 0;

		nFileSplittingSize2			= 0;	// MB
		nFileSplittingTime2			= 0;	// SEC
		nFileSplittingStatus2		= 0;

		nRecordScale2				= 0;
	}
	
} STRUCT_SRPEX, PSTRUCT_SRPEX;

/////////////////////////////////////////////////////////////////////////////
// CSC3B0Dlg dialog

class CSC3B0Dlg : public CDialog
{
// Construction
public:
	CSC3B0Dlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSC3B0Dlg)
	enum { IDD = IDD_SC3B0_DIALOG };
	CButton	m_btnSnapBmp;
	CButton	m_btnSnapJpg;
	CButton	m_btnMirrorv;
	CButton	m_btnMirrorh;
	CButton	m_btnStreamSetting;
	CButton	m_btnRcordSetting;
	CButton	m_btnStreamStop;
	CButton	m_btnStreamStart;
	CButton	m_btnRecordStop;
	CButton	m_btnRecordStart;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSC3B0Dlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CSC3B0Dlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnDestroy();
	afx_msg void OnButtonRecordStart();
	afx_msg void OnButtonRecordStop();
	afx_msg void OnButtonStreamStart();
	afx_msg void OnButtonStreamStop();
	afx_msg void OnButtonStreamApply();
	afx_msg void OnButtonRecordApply();
	afx_msg void OnButtonHMirror();
	afx_msg void OnButtonVMirror();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnButtonSnapJpg();
	afx_msg void OnButtonSnapBmp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:

//
// STATIC CLASS VARIABLE
//
	static CSC3B0Dlg*	s_pMainDlg;

	static CRect		s_rect_slipts_display[ 4 ];

public:

	CRect				GetWindowPos( ULONG nChannelNumber, ULONG nGridDivisions, ULONG nRendererWidth, ULONG nRendererHeight );

	BOOL				HwUninitialize();

	BOOL				HwInitialize();

	BOOL				GetAppPath( CHAR *&psz, ULONG nBuffSize );

	BOOL				OnLButtonDblClk_ChannelWindow( ULONG nID, UINT nFlags, CPoint point );

public:
	
	STRUCT_QCAP			m_srtQcap[ 4 ];

public:

	BOOL				OnStreamStart();
	BOOL				OnStreamStop();

	BOOL				OnRecordStart();
	BOOL				OnRecordStop();

	PVOID				m_hNetworkServer;
	volatile ULONG		m_nNetworkServerState;
	CRITICAL_SECTION	m_hNetworkServerAccessCriticalSection;

	BOOL 				m_bWndState;
	ULONG				m_nCurPlayChannel;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SC3B0DLG_H__5DBDB124_2FA4_4FA2_A7FA_1298C0C11B63__INCLUDED_)
