﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using QCAP.NET;

namespace StreamCatcherDemo2
{
    public partial class CPropertyDlg : Form
    {
        public Form1 m_pMainForm = null;

        public CPropertyDlg()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {

        }

        private void CPropertyDlg_Load(object sender, EventArgs e)
        {
            textPath.Text = m_pMainForm.g_scmProtypeEx.pszRecordFilePathName;

            m_comboEncodeType.Items.Add("HARDWARE");
            m_comboEncodeType.SelectedIndex = m_comboEncodeType.FindStringExact("HARDWARE");

            m_comboRecorFormat.Items.Add("H264");
            m_comboRecorFormat.SelectedIndex = m_comboRecorFormat.FindStringExact("H264");

            m_comboRecordProfile.Items.Add("BASELINE");
            m_comboRecordProfile.SelectedIndex = m_comboRecordProfile.FindStringExact("BASELINE");

            m_comboRecordSkipFrame.Items.Add("0");
            m_comboRecordSkipFrame.Items.Add("1/2");
            m_comboRecordSkipFrame.Items.Add("1/3");
            m_comboRecordSkipFrame.Items.Add("1/4");
            m_comboRecordSkipFrame.Items.Add("1/5");
            m_comboRecordSkipFrame.Items.Add("1/6");
            m_comboRecordSkipFrame.Items.Add("1/7");
            m_comboRecordSkipFrame.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nPostSkipFrameRate);

            string str = "";
            int pos = 0;
            uint nStandard = 25;
            if (m_pMainForm.g_scmProtypeEx.bSetting == false)
            {
                m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate = nStandard;
            }
            for (uint i = 0; i < nStandard + 1; i++)
            {
                str = Convert.ToString(i);
                pos = m_comboRecordAvgFrame.Items.Add(str);
                m_comboRecordAvgFrame.Items[pos] = str;

                if (m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate == i)
                {
                    m_comboRecordAvgFrame.SelectedIndex = (int)(i);
                }
            }

            m_comboRecordEntropy.Items.Add("CAVLC");
            m_comboRecordEntropy.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordEntropy);

            m_comboRecordMode.Items.Add("VBR");
            m_comboRecordMode.Items.Add("CBR");
            m_comboRecordMode.Items.Add("ABR");
            m_comboRecordMode.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordMode);

            str = Convert.ToString(m_pMainForm.g_scmProtypeEx.nQuality);
            m_editRecordQuality.Text = str;

            str = Convert.ToString(m_pMainForm.g_scmProtypeEx.nBitRate);
            m_editRecordBitrate.Text = str;

            str = Convert.ToString(m_pMainForm.g_scmProtypeEx.nGOP);
            m_editRecordGop.Text = str;

            m_comboFileTime.Items.Add("NONE");
            m_comboFileTime.Items.Add("60 SEC");
            m_comboFileTime.Items.Add("120 SEC");
            m_comboFileTime.Items.Add("180 SEC");
            m_comboFileTime.Items.Add("240 SEC");
            m_comboFileTime.Items.Add("300 SEC");
            m_comboFileTime.Items.Add("360 SEC");
            m_comboFileTime.Items.Add("420 SEC");
            m_comboFileTime.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nFileSplittingTime);

            m_comboFileSize.Items.Add("NONE");
            m_comboFileSize.Items.Add("1 MB");
            m_comboFileSize.Items.Add("5 MB");
            m_comboFileSize.Items.Add("10 MB");
            m_comboFileSize.Items.Add("20 MB");
            m_comboFileSize.Items.Add("40 MB");
            m_comboFileSize.Items.Add("80 MB");
            m_comboFileSize.Items.Add("160 MB");
            m_comboFileSize.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nFileSplittingSize);

            m_comboRecordScale.Items.Add("0");
            m_comboRecordScale.Items.Add("1/2");
            m_comboRecordScale.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordScale);


            radioSkipFps.TabStop = true;
            radioAvgFps.TabStop = false;
            radioSkipFps.Checked = true;

            radioSize.TabStop = true;
            radioTime.TabStop = false;
            radioSize.Checked = true;
            //
            //  SUB
            //
            m_comboEncodeType2.Items.Add("HARDWARE");
            //	        m_comboEncodeType.Items.IndexOf( 0 );
            m_comboEncodeType2.SelectedIndex = m_comboEncodeType2.FindStringExact("HARDWARE");

            m_comboRecorFormat2.Items.Add("H264");
            m_comboRecorFormat2.SelectedIndex = m_comboRecorFormat2.FindStringExact("H264");

            m_comboRecordProfile2.Items.Add("BASELINE");
            m_comboRecordProfile2.SelectedIndex = m_comboRecordProfile2.FindStringExact("BASELINE");

            m_comboRecordSkipFrame2.Items.Add("0");
            m_comboRecordSkipFrame2.Items.Add("1/2");
            m_comboRecordSkipFrame2.Items.Add("1/3");
            m_comboRecordSkipFrame2.Items.Add("1/4");
            m_comboRecordSkipFrame2.Items.Add("1/5");
            m_comboRecordSkipFrame2.Items.Add("1/6");
            m_comboRecordSkipFrame2.Items.Add("1/7");
            m_comboRecordSkipFrame2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nPostSkipFrameRate2);

            string str2 = "";
            int pos2 = 0;
            uint nStandard2 = 25;
            if (m_pMainForm.g_scmProtypeEx.bSetting == false)
            {
                m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate2 = nStandard2;
            }
            for (uint i = 0; i < nStandard2 + 1; i++)
            {
                str2 = Convert.ToString(i);
                pos2 = m_comboRecordAvgFrame2.Items.Add(str2);
                m_comboRecordAvgFrame2.Items[pos2] = str2;

                if (m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate2 == i)
                {
                    m_comboRecordAvgFrame2.SelectedIndex = (int)(i);
                }
            }

            m_comboRecordEntropy2.Items.Add("CAVLC");
            m_comboRecordEntropy2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordEntropy2);

            m_comboRecordMode2.Items.Add("VBR");
            m_comboRecordMode2.Items.Add("CBR");
            m_comboRecordMode2.Items.Add("ABR");
            m_comboRecordMode2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordMode2);

            str2 = Convert.ToString(m_pMainForm.g_scmProtypeEx.nQuality2);
            m_editRecordQuality2.Text = str2;

            str2 = Convert.ToString(m_pMainForm.g_scmProtypeEx.nBitRate2);
            m_editRecordBitrate2.Text = str2;

            str2 = Convert.ToString(m_pMainForm.g_scmProtypeEx.nGOP2);
            m_editRecordGop2.Text = str2;

            m_comboFileTime2.Items.Add("NONE");
            m_comboFileTime2.Items.Add("60 SEC");
            m_comboFileTime2.Items.Add("120 SEC");
            m_comboFileTime2.Items.Add("180 SEC");
            m_comboFileTime2.Items.Add("240 SEC");
            m_comboFileTime2.Items.Add("300 SEC");
            m_comboFileTime2.Items.Add("360 SEC");
            m_comboFileTime2.Items.Add("420 SEC");
            m_comboFileTime2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nFileSplittingTime2);

            m_comboFileSize2.Items.Add("NONE");
            m_comboFileSize2.Items.Add("1 MB");
            m_comboFileSize2.Items.Add("5 MB");
            m_comboFileSize2.Items.Add("10 MB");
            m_comboFileSize2.Items.Add("20 MB");
            m_comboFileSize2.Items.Add("40 MB");
            m_comboFileSize2.Items.Add("80 MB");
            m_comboFileSize2.Items.Add("160 MB");
            m_comboFileSize2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nFileSplittingSize2);

            m_comboRecordScale2.Items.Add("0");
            m_comboRecordScale2.Items.Add("1/2");
            m_comboRecordScale2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordScale2);

            radioSkipFps2.TabStop = true;
            radioAvgFps2.TabStop = false;
            radioSkipFps2.Checked = true;

            radioSize2.TabStop = true;
            radioTime2.TabStop = false;
            radioSize2.Checked = true;

            if (m_pMainForm.g_scmProtypeEx.bSetting == false) { m_pMainForm.g_scmProtypeEx.bSetting = true; }
        }

        private void buttonApply_Click(object sender, EventArgs e)
        {
            m_pMainForm.g_scmProtypeEx.pszRecordFilePathName = textPath.Text;

            m_pMainForm.g_scmProtypeEx.nPostSkipFrameRate = (uint)m_comboRecordSkipFrame.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate = (uint)m_comboRecordAvgFrame.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nRecordEntropy = (uint)m_comboRecordEntropy.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nRecordMode = (uint)m_comboRecordMode.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nQuality = (uint)Convert.ToInt32(m_editRecordQuality.Text);

            m_pMainForm.g_scmProtypeEx.nBitRate = (uint)Convert.ToInt32(m_editRecordBitrate.Text);

            m_pMainForm.g_scmProtypeEx.nGOP = (uint)Convert.ToInt32(m_editRecordGop.Text);

            m_pMainForm.g_scmProtypeEx.nFileSplittingTime = (uint)m_comboFileTime.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nFileSplittingSize = (uint)m_comboFileSize.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nRecordScale = (uint)m_comboRecordScale.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nPostSkipFrameRate = (uint)m_comboRecordSkipFrame.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate = (uint)m_comboRecordAvgFrame.SelectedIndex;

            if (radioSkipFps.Checked == true) { m_pMainForm.g_scmProtypeEx.nPostFrameRateStatus = 0; }
            if (radioAvgFps.Checked == true) { m_pMainForm.g_scmProtypeEx.nPostFrameRateStatus = 1; }

            uint nPostSkipFrameRate = m_pMainForm.g_scmProtypeEx.nPostSkipFrameRate;
            uint nPostAvgFrameRate = m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate;
            uint nPostFrameRateStatus = m_pMainForm.g_scmProtypeEx.nPostFrameRateStatus;

            m_pMainForm.g_scmProtypeEx.nFileSplittingSize = (uint)m_comboFileSize.SelectedIndex;
            m_pMainForm.g_scmProtypeEx.nFileSplittingTime = (uint)m_comboFileTime.SelectedIndex;
            if (radioSize.Checked == true) { m_pMainForm.g_scmProtypeEx.nFileSplittingStatus = 0; }
            if (radioTime.Checked == true) { m_pMainForm.g_scmProtypeEx.nFileSplittingStatus = 1; }

            uint nFileSplittingSize = m_pMainForm.g_scmProtypeEx.nFileSplittingSize; 
            uint nFileSplittingTime = m_pMainForm.g_scmProtypeEx.nFileSplittingTime;
            uint nFileSplittingStatus = m_pMainForm.g_scmProtypeEx.nFileSplittingStatus;

            uint nRecordScale = m_pMainForm.g_scmProtypeEx.nRecordScale;

            if (nFileSplittingSize == 0) { nFileSplittingSize = 0; }
            if (nFileSplittingSize == 1) { nFileSplittingSize = 1024; }
            if (nFileSplittingSize == 2) { nFileSplittingSize = 1024 * 5; }
            if (nFileSplittingSize == 3) { nFileSplittingSize = 1024 * 10; }
            if (nFileSplittingSize == 4) { nFileSplittingSize = 1024 * 20; }
            if (nFileSplittingSize == 5) { nFileSplittingSize = 1024 * 40; }
            if (nFileSplittingSize == 6) { nFileSplittingSize = 1024 * 80; }
            if (nFileSplittingSize == 7) { nFileSplittingSize = 1024 * 160; }
            if (nFileSplittingSize == 8) { nFileSplittingSize = 1024 * 320; }

            if (nFileSplittingTime == 0) { nFileSplittingTime = 0; }
            if (nFileSplittingTime == 1) { nFileSplittingTime = 60; }
            if (nFileSplittingTime == 2) { nFileSplittingTime = 60 * 2; }
            if (nFileSplittingTime == 3) { nFileSplittingTime = 60 * 3; }
            if (nFileSplittingTime == 4) { nFileSplittingTime = 60 * 4; }
            if (nFileSplittingTime == 5) { nFileSplittingTime = 60 * 5; }
            if (nFileSplittingTime == 6) { nFileSplittingTime = 60 * 6; }
            if (nFileSplittingTime == 7) { nFileSplittingTime = 60 * 7; }
            //
            //	SUB
            //
            m_pMainForm.g_scmProtypeEx.nPostSkipFrameRate2 = (uint)m_comboRecordSkipFrame2.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate2 = (uint)m_comboRecordAvgFrame2.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nRecordEntropy2 = (uint)m_comboRecordEntropy2.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nRecordMode2 = (uint)m_comboRecordMode2.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nQuality2 = (uint)Convert.ToInt32(m_editRecordQuality2.Text);

            m_pMainForm.g_scmProtypeEx.nBitRate2 = (uint)Convert.ToInt32(m_editRecordBitrate2.Text);

            m_pMainForm.g_scmProtypeEx.nGOP2 = (uint)Convert.ToInt32(m_editRecordGop2.Text);

            m_pMainForm.g_scmProtypeEx.nFileSplittingTime2 = (uint)m_comboFileTime2.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nFileSplittingSize2 = (uint)m_comboFileSize2.SelectedIndex;

            m_pMainForm.g_scmProtypeEx.nRecordScale2 = (uint)m_comboRecordScale2.SelectedIndex;

            if (radioSkipFps2.Checked == true) { m_pMainForm.g_scmProtypeEx.nPostFrameRateStatus2 = 0; }
            if (radioAvgFps2.Checked == true) { m_pMainForm.g_scmProtypeEx.nPostFrameRateStatus2 = 1; }

            uint nPostSkipFrameRate2 = m_pMainForm.g_scmProtypeEx.nPostSkipFrameRate2;
            uint nPostAvgFrameRate2 = m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate2;
            uint nPostFrameRateStatus2 = m_pMainForm.g_scmProtypeEx.nPostFrameRateStatus2;

            m_pMainForm.g_scmProtypeEx.nFileSplittingSize2 = (uint)m_comboFileSize2.SelectedIndex;
            m_pMainForm.g_scmProtypeEx.nFileSplittingTime2 = (uint)m_comboFileTime2.SelectedIndex;
            if (radioSize2.Checked == true) { m_pMainForm.g_scmProtypeEx.nFileSplittingStatus2 = 0; }
            if (radioTime2.Checked == true) { m_pMainForm.g_scmProtypeEx.nFileSplittingStatus2 = 1; }

            uint nFileSplittingSize2 = m_pMainForm.g_scmProtypeEx.nFileSplittingSize2;
            uint nFileSplittingTime2 = m_pMainForm.g_scmProtypeEx.nFileSplittingTime2;
            uint nFileSplittingStatus2 = m_pMainForm.g_scmProtypeEx.nFileSplittingStatus2;

            uint nRecordScale2 = m_pMainForm.g_scmProtypeEx.nRecordScale2;

            if (nFileSplittingSize2 == 0) { nFileSplittingSize2 = 0; }
            if (nFileSplittingSize2 == 1) { nFileSplittingSize2 = 1024; }
            if (nFileSplittingSize2 == 2) { nFileSplittingSize2 = 1024 * 5; }
            if (nFileSplittingSize2 == 3) { nFileSplittingSize2 = 1024 * 10; }
            if (nFileSplittingSize2 == 4) { nFileSplittingSize2 = 1024 * 20; }
            if (nFileSplittingSize2 == 5) { nFileSplittingSize2 = 1024 * 40; }
            if (nFileSplittingSize2 == 6) { nFileSplittingSize2 = 1024 * 80; }
            if (nFileSplittingSize2 == 7) { nFileSplittingSize2 = 1024 * 160; }
            if (nFileSplittingSize2 == 8) { nFileSplittingSize2 = 1024 * 320; }

            if (nFileSplittingTime2 == 0) { nFileSplittingTime2 = 0; }
            if (nFileSplittingTime2 == 1) { nFileSplittingTime2 = 60; }
            if (nFileSplittingTime2 == 2) { nFileSplittingTime2 = 60 * 2; }
            if (nFileSplittingTime2 == 3) { nFileSplittingTime2 = 60 * 3; }
            if (nFileSplittingTime2 == 4) { nFileSplittingTime2 = 60 * 4; }
            if (nFileSplittingTime2 == 5) { nFileSplittingTime2 = 60 * 5; }
            if (nFileSplittingTime2 == 6) { nFileSplittingTime2 = 60 * 6; }
            if (nFileSplittingTime2 == 7) { nFileSplittingTime2 = 60 * 7; }
            //
            //
            //
            uint nIsInterleaved = 0;
            if (m_pMainForm.g_scmProtypeEx.bIsInterleaved == true) { nIsInterleaved = 1; }
            if (m_pMainForm.g_scmProtypeEx.bIsInterleaved == false) { nIsInterleaved = 0; }
            for (uint i = 0; i < 4; i++)
            {
                if (nPostFrameRateStatus == 0)
                {
                    EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(
                        m_pMainForm.strQcap[i].m_hVideoDevice,
                        0,
                        m_pMainForm.g_scmProtypeEx.nEncoderFormat,
                        m_pMainForm.g_scmProtypeEx.nRecordProfile,
                        m_pMainForm.g_scmProtypeEx.nRecordLevel,
                        m_pMainForm.g_scmProtypeEx.nRecordEntropy,
                        m_pMainForm.g_scmProtypeEx.nRecordMode,
                        m_pMainForm.g_scmProtypeEx.nQuality,
                        m_pMainForm.g_scmProtypeEx.nBitRate,
                        m_pMainForm.g_scmProtypeEx.nGOP,
                        m_pMainForm.g_scmProtypeEx.nBFrames,
                        nIsInterleaved,
                        0,0,0,
                        m_pMainForm.g_scmProtypeEx.nAspectRatioX,
                        m_pMainForm.g_scmProtypeEx.nAspectRatioY,
                        m_pMainForm.g_scmProtypeEx.nCropX,
                        m_pMainForm.g_scmProtypeEx.nCropY,
                        m_pMainForm.g_scmProtypeEx.nCropW,
                        m_pMainForm.g_scmProtypeEx.nCropH,
                        m_pMainForm.g_scmProtypeEx.nRecordScale,
                        m_pMainForm.g_scmProtypeEx.nPostSkipFrameRate,
                        0);
                }
                if (nPostFrameRateStatus == 1)
                {
                    EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(
                         m_pMainForm.strQcap[i].m_hVideoDevice,
                         0,
                         m_pMainForm.g_scmProtypeEx.nEncoderFormat,
                         m_pMainForm.g_scmProtypeEx.nRecordProfile,
                         m_pMainForm.g_scmProtypeEx.nRecordLevel,
                         m_pMainForm.g_scmProtypeEx.nRecordEntropy,
                         m_pMainForm.g_scmProtypeEx.nRecordMode,
                         m_pMainForm.g_scmProtypeEx.nQuality,
                         m_pMainForm.g_scmProtypeEx.nBitRate,
                         m_pMainForm.g_scmProtypeEx.nGOP,
                         m_pMainForm.g_scmProtypeEx.nBFrames,
                         nIsInterleaved,
                         0,0,0,
                         m_pMainForm.g_scmProtypeEx.nAspectRatioX,
                         m_pMainForm.g_scmProtypeEx.nAspectRatioY,
                         m_pMainForm.g_scmProtypeEx.nCropX,
                         m_pMainForm.g_scmProtypeEx.nCropY,
                         m_pMainForm.g_scmProtypeEx.nCropW,
                         m_pMainForm.g_scmProtypeEx.nCropH,
                         m_pMainForm.g_scmProtypeEx.nRecordScale,
                         0,
                         m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate);
                }
                if (nPostFrameRateStatus2 == 0)
                {
                    EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(
                        m_pMainForm.strQcap[i].m_hVideoDevice,
                        1,
                        m_pMainForm.g_scmProtypeEx.nEncoderFormat2,
                        m_pMainForm.g_scmProtypeEx.nRecordProfile2,
                        m_pMainForm.g_scmProtypeEx.nRecordLevel2,
                        m_pMainForm.g_scmProtypeEx.nRecordEntropy2,
                        m_pMainForm.g_scmProtypeEx.nRecordMode2,
                        m_pMainForm.g_scmProtypeEx.nQuality2,
                        m_pMainForm.g_scmProtypeEx.nBitRate2,
                        m_pMainForm.g_scmProtypeEx.nGOP2,
                        m_pMainForm.g_scmProtypeEx.nBFrames2,
                        nIsInterleaved,
                        0,0,0,
                        m_pMainForm.g_scmProtypeEx.nAspectRatioX2,
                        m_pMainForm.g_scmProtypeEx.nAspectRatioY2,
                        m_pMainForm.g_scmProtypeEx.nCropX2,
                        m_pMainForm.g_scmProtypeEx.nCropY2,
                        m_pMainForm.g_scmProtypeEx.nCropW2,
                        m_pMainForm.g_scmProtypeEx.nCropH2,
                        m_pMainForm.g_scmProtypeEx.nRecordScale2,
                        m_pMainForm.g_scmProtypeEx.nPostSkipFrameRate2,
                        0);
                }
                if (nPostFrameRateStatus2 == 1)
                {
                    EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(
                         m_pMainForm.strQcap[i].m_hVideoDevice,
                         1,
                         m_pMainForm.g_scmProtypeEx.nEncoderFormat2,
                         m_pMainForm.g_scmProtypeEx.nRecordProfile2,
                         m_pMainForm.g_scmProtypeEx.nRecordLevel2,
                         m_pMainForm.g_scmProtypeEx.nRecordEntropy2,
                         m_pMainForm.g_scmProtypeEx.nRecordMode2,
                         m_pMainForm.g_scmProtypeEx.nQuality2,
                         m_pMainForm.g_scmProtypeEx.nBitRate2,
                         m_pMainForm.g_scmProtypeEx.nGOP2,
                         m_pMainForm.g_scmProtypeEx.nBFrames2,
                         nIsInterleaved,
                         0,0,0,
                         m_pMainForm.g_scmProtypeEx.nAspectRatioX2,
                         m_pMainForm.g_scmProtypeEx.nAspectRatioY2,
                         m_pMainForm.g_scmProtypeEx.nCropX2,
                         m_pMainForm.g_scmProtypeEx.nCropY2,
                         m_pMainForm.g_scmProtypeEx.nCropW2,
                         m_pMainForm.g_scmProtypeEx.nCropH2,
                         m_pMainForm.g_scmProtypeEx.nRecordScale2,
                         0,
                         m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate2);
                }
            }
            //
            //
            //
            m_pMainForm.m_btnRecordStart.Enabled = true;

            m_pMainForm.m_btnRecordStop.Enabled = false;

            m_pMainForm.m_btnStreamStart.Enabled = true;

            m_pMainForm.m_btnStreamStop.Enabled = false;            

            this.Hide();
        }

        private void buttonDefault_Click(object sender, EventArgs e)
        {
            m_pMainForm.g_scmProtypeEx.SetDefaulVlaue();

            textPath.Text = m_pMainForm.g_scmProtypeEx.pszRecordFilePathName;

            m_comboEncodeType.SelectedIndex = 0;

            m_comboRecorFormat.SelectedIndex = 0;

            m_comboRecordProfile.SelectedIndex = 0;

            m_comboRecordSkipFrame.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nPostSkipFrameRate);
            
            m_comboRecordAvgFrame.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate);

            m_comboRecordEntropy.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordEntropy);

            m_comboRecordMode.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordMode);

            string str;
            str = Convert.ToString(m_pMainForm.g_scmProtypeEx.nQuality);
            m_editRecordQuality.Text = str;

            str = Convert.ToString(m_pMainForm.g_scmProtypeEx.nBitRate);
            m_editRecordBitrate.Text = str;

            str = Convert.ToString(m_pMainForm.g_scmProtypeEx.nGOP);
            m_editRecordGop.Text = str;

            m_comboFileTime.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nFileSplittingTime);

            m_comboFileSize.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nFileSplittingSize);

            m_comboRecordScale.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordScale);
//
//  SUB
//
            m_comboEncodeType2.SelectedIndex = 0;

            m_comboRecorFormat2.SelectedIndex = 0;

            m_comboRecordProfile2.SelectedIndex = 0;

            m_comboRecordSkipFrame2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nPostSkipFrameRate2);

            m_comboRecordAvgFrame2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nPostAvgFrameRate2);

            m_comboRecordEntropy2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordEntropy2);

            m_comboRecordMode2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordMode2);

            string str2;
            str2 = Convert.ToString(m_pMainForm.g_scmProtypeEx.nQuality2);
            m_editRecordQuality2.Text = str2;

            str2 = Convert.ToString(m_pMainForm.g_scmProtypeEx.nBitRate2);
            m_editRecordBitrate2.Text = str2;

            str2 = Convert.ToString(m_pMainForm.g_scmProtypeEx.nGOP2);
            m_editRecordGop2.Text = str2;

            m_comboFileTime2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nFileSplittingTime2);

            m_comboFileSize2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nFileSplittingSize2);

            m_comboRecordScale2.SelectedIndex = (int)(m_pMainForm.g_scmProtypeEx.nRecordScale2);
        }
    }
}
