// ColorKeyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ColorKey.h"
#include "ColorKeyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

struct _colorkeystuff
{
	BYTE Alpha;
	BYTE Red;
	BYTE Green;
	BYTE Blue;
	BYTE Threshold;

	_colorkeystuff() :
	Alpha	 ( 0xFF ),
	Red		 ( 0x00 ),
	Green	 ( 0x00 ),
	Blue	 ( 0xFF ),
	Threshold( 0x10 ){}
} clrkey;

CColorKeyDlg *CColorKeyDlg::s_pColorKeyDlg = 0;

ULONG g_n_repeat_status = 0;

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CColorKeyDlg *pColorKeyDlg = CColorKeyDlg::s_pColorKeyDlg;

	ULONG nChannelNumber = (ULONG)(pUserData);

	pColorKeyDlg->m_nVideoWidth[ nChannelNumber ] = 0;
	
	pColorKeyDlg->m_nVideoHeight[ nChannelNumber ] = 0;
	
	pColorKeyDlg->m_bVideoIsInterleaved[ nChannelNumber ] = FALSE;
	
	pColorKeyDlg->m_dVideoFrameRate[ nChannelNumber ] = 0.0;
	
	pColorKeyDlg->m_nAudioChannels[ nChannelNumber ] = 0; 
	
	pColorKeyDlg->m_nAudioBitsPerSample[ nChannelNumber ] = 0;
	
	pColorKeyDlg->m_nAudioSampleFrequency[ nChannelNumber ] = 0;

	pColorKeyDlg->GetDlgItem( IDC_STATIC_FORMAT )->SetWindowText( "INFO: ..." );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CColorKeyDlg *pColorKeyDlg = CColorKeyDlg::s_pColorKeyDlg;

	ULONG nChannelNumber = (ULONG)(pUserData);

	pColorKeyDlg->m_nVideoWidth[ nChannelNumber ] = 0;
	
	pColorKeyDlg->m_nVideoHeight[ nChannelNumber ] = 0;
	
	pColorKeyDlg->m_bVideoIsInterleaved[ nChannelNumber ] = FALSE;
	
	pColorKeyDlg->m_dVideoFrameRate[ nChannelNumber ] = 0.0;
	
	pColorKeyDlg->m_nAudioChannels[ nChannelNumber ] = 0; 
	
	pColorKeyDlg->m_nAudioBitsPerSample[ nChannelNumber ] = 0;
	
	pColorKeyDlg->m_nAudioSampleFrequency[ nChannelNumber ] = 0;

	pColorKeyDlg->GetDlgItem( IDC_STATIC_FORMAT )->SetWindowText( "INFO: ..." );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CColorKeyDlg *pColorKeyDlg = CColorKeyDlg::s_pColorKeyDlg;

	ULONG nChannelNumber = (ULONG)(pUserData);

	pColorKeyDlg->m_nVideoWidth[ nChannelNumber ] = nVideoWidth;
	
	pColorKeyDlg->m_nVideoHeight[ nChannelNumber ] = nVideoHeight;
	
	pColorKeyDlg->m_bVideoIsInterleaved[ nChannelNumber ] = bVideoIsInterleaved;
	
	pColorKeyDlg->m_dVideoFrameRate[ nChannelNumber ] = dVideoFrameRate;
	
	pColorKeyDlg->m_nAudioChannels[ nChannelNumber ] = nAudioChannels; 
	
	pColorKeyDlg->m_nAudioBitsPerSample[ nChannelNumber ] = nAudioBitsPerSample;
	
	pColorKeyDlg->m_nAudioSampleFrequency[ nChannelNumber ] = nAudioSampleFrequency;

	CHAR psz[ MAX_PATH ];

	if( bVideoIsInterleaved == TRUE ) {

		sprintf( psz, "INFO: %dx%dI@%2.3fFPS, %dx%dBITSx%dHZ", nVideoWidth, nVideoHeight * 1, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

		pColorKeyDlg->GetDlgItem( IDC_STATIC_FORMAT )->SetWindowText( psz );
	}
	else {

		sprintf( psz, "INFO: %dx%dP@%2.3fFPS, %dx%dBITSx%dHZ", nVideoWidth, nVideoHeight * 1, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

		pColorKeyDlg->GetDlgItem( IDC_STATIC_FORMAT )->SetWindowText( psz );
	}
	return QCAP_RT_OK;
}

BYTE * g_p_video_frame_buffer_background = NULL;

ULONG  g_n_video_frame_length_background = 0;

BYTE * g_p_video_frame_buffer_foreground = NULL;

ULONG  g_n_video_frame_length_foreground = 0;

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CColorKeyDlg *pColorKeyDlg = CColorKeyDlg::s_pColorKeyDlg;

	ULONG nChannelNumber = (ULONG)(pUserData);

	static ULONG counts[ 2 ] = { 0, 0 };

	if( pColorKeyDlg->m_bVideoIsInterleaved[ nChannelNumber ] == FALSE &&

		pColorKeyDlg->m_dVideoFrameRate[ nChannelNumber ] >= 50.0 ) {

		if( counts[ nChannelNumber ]++ % 2 ) { 
			
			return QCAP_RT_OK; 
		}
	}

	//Background channel
	//
	EnterCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 0 ] );

		if ( ((pColorKeyDlg->m_nShareRecordState[ 0 ] >> 0) & 0x00000001) )	
		{ 
				if( nChannelNumber  == 0 )
				{
					if( pColorKeyDlg->m_hShareRecordThreadBufferReadyEvent[ 0 ] ) {

						g_p_video_frame_buffer_background = pFrameBuffer;

						g_n_video_frame_length_background = nFrameBufferLen;

						SetEvent( pColorKeyDlg->m_hShareRecordThreadBufferReadyEvent[ 0 ] );

					}
				}
		}
	LeaveCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 0 ] );

	//Foreground channel
	//
	EnterCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 1 ] );

		if ( ((pColorKeyDlg->m_nShareRecordState[ 1 ] >> 0) & 0x00000001) )	
		{ 
			if( pColorKeyDlg->nSelectType == 1 )
			{
				if( nChannelNumber  == 1 )
				{
					if( pColorKeyDlg->m_hShareRecordThreadBufferReadyEvent[ 1 ] ) {

						g_p_video_frame_buffer_foreground  = pFrameBuffer;

						g_n_video_frame_length_foreground  = nFrameBufferLen;

						SetEvent( pColorKeyDlg->m_hShareRecordThreadBufferReadyEvent[ 1 ] );

					}
				}
			}
		}
	LeaveCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 1 ] );

	return QCAP_RT_OK;

}

DWORD WINAPI on_process_share_record_video_background( LPVOID params )
{
	CColorKeyDlg *pColorKeyDlg = CColorKeyDlg::s_pColorKeyDlg;

	HANDLE events[ 2 ] = { pColorKeyDlg->m_hShareRecordThreadStopEvent[ 0 ], 

						   pColorKeyDlg->m_hShareRecordThreadBufferReadyEvent[ 0 ] };

	while( TRUE ) {

		DWORD returns = WaitForMultipleObjects( 2, events, FALSE, INFINITE );

		if( returns == (WAIT_OBJECT_0) ) { break ; }

		if( returns == (WAIT_OBJECT_0 + 1) ) {

			EnterCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 0 ] );

			BYTE * pShareFrameBuffer = g_p_video_frame_buffer_background;

			ULONG  nShareFrameBufferLen = g_n_video_frame_length_background;

				if ( ((pColorKeyDlg->m_nShareRecordState[ 0 ] >> 0) & 0x00000001) )	
				{ 

						QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER(	0,
				
												QCAP_COLORSPACE_TYEP_YUY2, 
											
												pColorKeyDlg->m_nVideoWidth[ 0 ], 
																						 
												pColorKeyDlg->m_nVideoHeight[ 0 ], 
																						 
												pShareFrameBuffer, 
																						 
												nShareFrameBufferLen );		
			}
			LeaveCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 0 ] );
		}
	}
	return 0;
}


DWORD WINAPI on_process_share_record_video_foreground( LPVOID params )
{
	CColorKeyDlg *pColorKeyDlg = CColorKeyDlg::s_pColorKeyDlg;

	HANDLE events[ 2 ] = { pColorKeyDlg->m_hShareRecordThreadStopEvent[ 1 ], 

						   pColorKeyDlg->m_hShareRecordThreadBufferReadyEvent[ 1 ] };

	while( TRUE ) {

		DWORD returns = WaitForMultipleObjects( 2, events, FALSE, INFINITE );

		if( returns == (WAIT_OBJECT_0) ) { break ; }

		if( returns == (WAIT_OBJECT_0 + 1) ) {

			EnterCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 1 ] );

					ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

					BYTE threshold = clrkey.Threshold;

					BYTE * pShareFrameBuffer = g_p_video_frame_buffer_foreground ;

					ULONG  nShareFrameBufferLen = g_n_video_frame_length_foreground ;

						if ( ((pColorKeyDlg->m_nShareRecordState[ 1 ] >> 0) & 0x00000001) )	
						{ 

							QCAP_SET_OSD_SHARE_RECORD_BUFFER( 0, 0, 0, 0, 0, 0,
								
												QCAP_COLORSPACE_TYEP_YUY2,
													
												pShareFrameBuffer,
													
												pColorKeyDlg->m_nVideoWidth[ 1 ],
													
												pColorKeyDlg->m_nVideoHeight[ 1 ],
													
												0,
													
												clrkey.Alpha,
													
												colorkey,
													
												threshold );
						}
			LeaveCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 1 ] );
		}
	}
	return 0;
}


// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CColorKeyDlg *pColorKeyDlg = CColorKeyDlg::s_pColorKeyDlg;

	ULONG nChannelNumber = (ULONG)(pUserData);

	if( nChannelNumber == 0 )
	{

	QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );

	}
	
    return QCAP_RT_OK;
}

BYTE * g_p_video_file_frame_buffer = NULL;

ULONG  g_n_video_file_frame_length = 0;

QRETURN on_video_decoder_file_callback( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CColorKeyDlg *pColorKeyDlg = CColorKeyDlg::s_pColorKeyDlg;

	EnterCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 2 ] );

		if ( ((pColorKeyDlg->m_nShareRecordState[ 2 ] >> 0) & 0x00000001) )	
		{ 
			if( pColorKeyDlg->nSelectType == 2 )
			{
				if( pColorKeyDlg->m_hShareRecordThreadBufferReadyEvent[ 2 ] ) {

					g_p_video_file_frame_buffer = pFrameBuffer;

					g_n_video_file_frame_length = nFrameBufferLen;

					SetEvent( pColorKeyDlg->m_hShareRecordThreadBufferReadyEvent[ 2 ] );

				}
			}
		}
	LeaveCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 2 ] );

	return QCAP_RT_OK;
}

DWORD WINAPI on_process_share_record_video_file( LPVOID params )
{
	CColorKeyDlg *pColorKeyDlg = CColorKeyDlg::s_pColorKeyDlg;

	HANDLE events[ 2 ] = { pColorKeyDlg->m_hShareRecordThreadStopEvent[ 2 ], 

						   pColorKeyDlg->m_hShareRecordThreadBufferReadyEvent[ 2 ] };

	while( TRUE ) {

		DWORD returns = WaitForMultipleObjects( 2, events, FALSE, INFINITE );

		if( returns == (WAIT_OBJECT_0) ) { break ; }

		if( returns == (WAIT_OBJECT_0 + 1) ) {

			EnterCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 2 ] );

				ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

				BYTE threshold = clrkey.Threshold;

				BYTE * pVideoFrameBuffer = g_p_video_file_frame_buffer ;

				ULONG  nVideoFrameBufferLen = g_n_video_file_frame_length ;

					if ( ((pColorKeyDlg->m_nShareRecordState[ 2 ] >> 0) & 0x00000001) )	
					{ 

						QCAP_SET_OSD_SHARE_RECORD_BUFFER( 0, 0, 284, 0, 1352, 1080,
								
												QCAP_COLORSPACE_TYEP_YV12,
													
												pVideoFrameBuffer,
													
												pColorKeyDlg->m_nFileVideoWidth,
													
												pColorKeyDlg->m_nFileVideoHeight,
													
												0,
													
												clrkey.Alpha,
													
												colorkey,
													
												threshold );

					}
			LeaveCriticalSection(  &pColorKeyDlg->m_hShareRecordAccessCriticalSections[ 2 ] );
		}
	}

    return QCAP_RT_OK;
}




QRETURN on_audio_decoder_file_callback( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	return QCAP_RT_OK;
}



/////////////////////////////////////////////////////////////////////////////
// CColorKeyDlg dialog

CColorKeyDlg::CColorKeyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CColorKeyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CColorKeyDlg)
	m_static_alpha = _T("");
	m_static_b = _T("");
	m_static_g = _T("");
	m_static_r = _T("");
	m_static_threshold = _T("");
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CColorKeyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CColorKeyDlg)

	DDX_Control(pDX, IDC_SLIDER_THRESHOLD, m_scroll_threshold);
	DDX_Control(pDX, IDC_SLIDER_R, m_scroll_r);
	DDX_Control(pDX, IDC_SLIDER_G, m_scroll_g);
	DDX_Control(pDX, IDC_SLIDER_B, m_scroll_b);
	DDX_Control(pDX, IDC_SLIDER_ALPHA, m_scroll_alpha);
	DDX_Text(pDX, IDC_STATIC_ALPHA, m_static_alpha);
	DDX_Text(pDX, IDC_STATIC_B, m_static_b);
	DDX_Text(pDX, IDC_STATIC_G, m_static_g);
	DDX_Text(pDX, IDC_STATIC_R, m_static_r);
	DDX_Text(pDX, IDC_STATIC_THRESHOLD, m_static_threshold);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_STATIC_DISPLAY, m_statWindow);
}

BEGIN_MESSAGE_MAP(CColorKeyDlg, CDialog)
	//{{AFX_MSG_MAP(CColorKeyDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()

	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_ALPHA, OnReleasedcaptureSliderAlpha)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_B, OnReleasedcaptureSliderB)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_G, OnReleasedcaptureSliderG)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_R, OnReleasedcaptureSliderR)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_THRESHOLD, OnReleasedcaptureSliderThreshold)
	ON_BN_CLICKED(IDC_RADIO_FILE, OnRadioFile)
	ON_BN_CLICKED(IDC_RADIO_SOURCE, OnRadioSource)
	ON_WM_TIMER()
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP


END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorKeyDlg message handlers


BOOL CColorKeyDlg::OnShareRecordStart()
{
	// TODO: Add your control notification handler code here

	OnShareRecordStop();
	
	QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 100 );

	QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, 1920, 1080, 30, QCAP_RECORD_MODE_CBR, 8000, 6*1024*1024, 30, 0, 0, GetDlgItem( IDC_STATIC_DISPLAY )->m_hWnd, TRUE, FALSE );

	QCAP_START_SHARE_RECORD( 0, "DEMO.MP4", 0x00000004 );

	EnterCriticalSection( &m_hShareRecordAccessCriticalSections[ 0 ] );

	m_nShareRecordState[ 0 ] = m_nShareRecordState[ 0 ] | (0x00000001 << 0);

	LeaveCriticalSection( &m_hShareRecordAccessCriticalSections[ 0 ] );

	EnterCriticalSection( &m_hShareRecordAccessCriticalSections[ 1 ] );

	m_nShareRecordState[ 1 ] = m_nShareRecordState[ 1 ] | (0x00000001 << 0);

	LeaveCriticalSection( &m_hShareRecordAccessCriticalSections[ 1 ] );
	
	return TRUE;
}

BOOL CColorKeyDlg::OnShareRecordStop()
{
	EnterCriticalSection( &m_hShareRecordAccessCriticalSections[ 0 ] );

	m_nShareRecordState[ 0 ] = m_nShareRecordState[ 0 ] ^ (0x00000001 << 0);

	LeaveCriticalSection( &m_hShareRecordAccessCriticalSections[ 0 ] );

	EnterCriticalSection( &m_hShareRecordAccessCriticalSections[ 1 ] );

	m_nShareRecordState[ 1 ] = m_nShareRecordState[ 1 ] ^ (0x00000001 << 0);

	LeaveCriticalSection( &m_hShareRecordAccessCriticalSections[ 1 ] );

	EnterCriticalSection( &m_hShareRecordAccessCriticalSections[ 2 ] );

	m_nShareRecordState[ 2 ] = m_nShareRecordState[ 2 ] ^ (0x00000001 << 0);

	LeaveCriticalSection( &m_hShareRecordAccessCriticalSections[ 2 ] );

	QCAP_STOP_SHARE_RECORD( 0 );
	
	return TRUE;
}


BOOL CColorKeyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	CColorKeyDlg::s_pColorKeyDlg = this;

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//
	for( ULONG i = 0; i < 2; i++ )
	{
		m_hDevice[ i ] = NULL;

		m_nVideoWidth[ i ] = 0;
		
		m_nVideoHeight[ i ] = 0;
		
		m_dVideoFrameRate[ i ] = 0.0;

		m_bVideoIsInterleaved[ i ] = 0;
		
		m_nAudioChannels[ i ] = 0; 
		
		m_nAudioBitsPerSample[ i ] = 0;
		
		m_nAudioSampleFrequency[ i ] = 0;	
	}

	//2014.06.27
	//
	for( ULONG i = 0; i < 3; i++ )
	{

		m_nShareRecordState[ i ] = 0;

		InitializeCriticalSection( &m_hShareRecordAccessCriticalSections[ i ] );

		m_hShareRecordThreadStopEvent[ i ] = NULL;

		m_hShareRecordThreadBufferReadyEvent[ i ] = NULL;

		m_hShareRecordThread[ i ] = NULL;

		m_hShareRecordThreadNumber[ i ]  = 0;
	}

	nSelectType = 0;

	m_progTimeBar.SetRange( 0, 100 );

	m_pFile = 0;

	m_nFileVideoFormat = 0;

	m_nFileVideoWidth = 0;

	m_nFileVideoHeight = 0;

	m_dFileVideoFrameRate = 0.0;

	m_nFileAudioFormat = 0;

	m_nFileAudioChannels = 0;

	m_nFileAudioBitsPerSample = 0;

	m_nFileAudioSampleFrequency = 0;

	m_dFileTotalDuationTimes = 0;

	m_nFileTotalVideoFrames = 0;

	m_nFileTotalAudioFrames = 0;

	// INITIALIZE SCROLL 
	//
	{
		m_scroll_alpha.SetRange( 0, 255, TRUE );
		m_scroll_b.SetRange( 0, 255, TRUE );
		m_scroll_g.SetRange( 0, 255, TRUE );
		m_scroll_r.SetRange( 0, 255, TRUE );
		m_scroll_threshold.SetRange( 0, 127, TRUE );

		m_scroll_alpha.SetPos( clrkey.Alpha );
		m_scroll_b.SetPos( clrkey.Blue );
		m_scroll_g.SetPos( clrkey.Green );
		m_scroll_r.SetPos( clrkey.Red );
		m_scroll_threshold.SetPos( clrkey.Threshold );

		m_static_alpha.Format( "%i", clrkey.Alpha );
		m_static_b.Format( "%i", clrkey.Blue );
		m_static_g.Format( "%i", clrkey.Green );
		m_static_r.Format( "%i", clrkey.Red );
		m_static_threshold.Format( "%i", clrkey.Threshold );

		UpdateData(FALSE);	
	}	
	for(ULONG i = 0; i < 2; i++ )
	{
		// INITIALIZE DEVICE RESOURCE
		if( i == 0 ) { QCAP_CREATE( "SA7160 PCI", i, GetDlgItem( IDC_STATIC_BK_DISPLAY )->m_hWnd, &m_hDevice[ i ], TRUE ); }
		if( i == 1 ) { QCAP_CREATE( "SA7160 PCI", i, GetDlgItem( IDC_STATIC_FORE_DISPLAY )->m_hWnd, &m_hDevice[ i ], TRUE ); }

		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hDevice[ i ], on_format_changed_callback, (PVOID)i );

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hDevice[ i ], on_no_signal_detected_callback, (PVOID)i );

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hDevice[ i ], on_no_signal_removed_callback, (PVOID)i );

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hDevice[ i ], on_video_preview_callback, (PVOID)i );

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hDevice[ i ], on_audio_preview_callback, (PVOID)i );

		QCAP_SET_VIDEO_INPUT( m_hDevice[ i ], QCAP_INPUT_TYPE_SDI );

		//QCAP_SET_AUDIO_INPUT( m_hDevice[ i ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

		QCAP_SET_AUDIO_VOLUME( m_hDevice[ i ], 0 );

		QCAP_RUN( m_hDevice[ i ] );
	}

	QCAP_SET_AUDIO_INPUT( m_hDevice[ 0 ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO ); 

	QCAP_SET_AUDIO_VOLUME( m_hDevice[ 0 ], 0 );

	QCAP_SET_AUDIO_INPUT( m_hDevice[ 1 ], QCAP_INPUT_TYPE_LINE_IN ); 

	QCAP_SET_AUDIO_VOLUME( m_hDevice[ 1 ], 0 );

	LeaveCriticalSection(  &m_hShareRecordAccessCriticalSections[ 0 ] );

	LeaveCriticalSection(  &m_hShareRecordAccessCriticalSections[ 1 ] );

	LeaveCriticalSection(  &m_hShareRecordAccessCriticalSections[ 2 ] );	

	GetDlgItem( IDC_STATIC_BK_DISPLAY )->ShowWindow( TRUE );

	GetDlgItem( IDC_STATIC_FORE_DISPLAY )->ShowWindow( TRUE );

	OnShareRecordStart();

	// 2014.06.27
	//
	m_hShareRecordThreadStopEvent[ 0 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	m_hShareRecordThreadBufferReadyEvent[ 0 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	m_hShareRecordThread[ 0 ] = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)(on_process_share_record_video_background), (LPVOID)(this), 0, &m_hShareRecordThreadNumber[ 0 ] );

	m_hShareRecordThreadStopEvent[ 1 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	m_hShareRecordThreadBufferReadyEvent[ 1 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	m_hShareRecordThread[ 1 ] = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)(on_process_share_record_video_foreground), (LPVOID)(this), 0, &m_hShareRecordThreadNumber[ 1 ] );

	m_hShareRecordThreadStopEvent[ 2 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	m_hShareRecordThreadBufferReadyEvent[ 2 ] = CreateEvent( NULL, FALSE, FALSE, NULL );

	m_hShareRecordThread[ 2 ] = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)(on_process_share_record_video_file), (LPVOID)(this), 0, &m_hShareRecordThreadNumber[ 2 ] );

	//2014.07.04
	//
	m_isFullScreen = false;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CColorKeyDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CColorKeyDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CColorKeyDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CColorKeyDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CColorKeyDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	OnShareRecordStop();

	// UNINITIALIZE DEVICE RESOURCE
	// 
	for( ULONG i = 0; i < 3; i++ )
	{
		{	EnterCriticalSection( &m_hShareRecordAccessCriticalSections[ i ] );

				m_nShareRecordState[ i ] = 0x00000000;

				LeaveCriticalSection( &m_hShareRecordAccessCriticalSections[ i ] );

				Sleep( 30 );

				{	if( m_hShareRecordThreadStopEvent ) { SetEvent( m_hShareRecordThreadStopEvent[ i ] ); }

					CLOSE_THREAD( m_hShareRecordThread[ i ] );

					if( m_hShareRecordThreadStopEvent[ i ] != NULL ) {

						CloseHandle( m_hShareRecordThreadStopEvent[ i ] );

						m_hShareRecordThreadStopEvent[ i ] = NULL;
				}
					if( m_hShareRecordThreadBufferReadyEvent[ i ] != NULL ) {

						CloseHandle( m_hShareRecordThreadBufferReadyEvent[ i ] );

						m_hShareRecordThreadBufferReadyEvent[ i ] = NULL;
					}
				}	 
		}
	}

	if( m_pFile ) {

		QCAP_DESTROY_FILE( m_pFile );

		m_pFile = NULL;
	}

	for( ULONG i = 0; i < 2; i++ )
	{
		if( m_hDevice[ i ] ) {

			QCAP_STOP( m_hDevice[ i ] );

			QCAP_DESTROY( m_hDevice[ i ] );

			m_hDevice[ i ] = NULL;
		}
	}

	DeleteCriticalSection( &m_hShareRecordAccessCriticalSections[ 0 ] );

	DeleteCriticalSection( &m_hShareRecordAccessCriticalSections[ 1 ] );

	DeleteCriticalSection( &m_hShareRecordAccessCriticalSections[ 2 ] );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();	
}


void CColorKeyDlg::OnReleasedcaptureSliderAlpha(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;
}

void CColorKeyDlg::OnReleasedcaptureSliderB(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	*pResult = 0;
}

void CColorKeyDlg::OnReleasedcaptureSliderG(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	*pResult = 0;
}

void CColorKeyDlg::OnReleasedcaptureSliderR(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	*pResult = 0;
}

void CColorKeyDlg::OnReleasedcaptureSliderThreshold(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here

	*pResult = 0;
}

void CColorKeyDlg::OnRadioSource() 
{
	// TODO: Add your control notification handler code here

	nSelectType = 1;

	GetDlgItem( IDC_RADIO_SOURCE )->ShowWindow( TRUE );

	GetDlgItem( IDC_RADIO_FILE )->ShowWindow( FALSE );
}



void CColorKeyDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	if( nIDEvent == 0x00000000 ) {

		if( m_pFile ) {

			double dSampleTime = 0;

			ULONG dStopSampleTime = (int)(m_nFileTotalVideoFrames / m_dFileVideoFrameRate);

			QCAP_GET_FILE_POSITION( m_pFile, &dSampleTime );

			if( g_n_repeat_status )
			{
				if( dSampleTime > dStopSampleTime )
				{
					QCAP_STOP_FILE( m_pFile );

					QCAP_PLAY_FILE( m_pFile );
				}			
			}
		}
	}
	
	CDialog::OnTimer(nIDEvent);
}

void CColorKeyDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default

	if( nSBCode == 0x08 ) { return; }

	EnterCriticalSection(  &m_hShareRecordAccessCriticalSections[ 2 ] );

	if( pScrollBar->m_hWnd == m_scroll_alpha.m_hWnd )
	{
		clrkey.Alpha = nPos;		

		ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

		BYTE threshold = clrkey.Threshold;

		pScrollBar->SetScrollPos( SB_HORZ, nPos );

		m_static_alpha.Format( "%i", clrkey.Alpha );

		UpdateData( FALSE );
	}

	if( pScrollBar->m_hWnd == m_scroll_r.m_hWnd )
	{
		clrkey.Red = nPos;

		ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

		BYTE threshold = clrkey.Threshold;

		pScrollBar->SetScrollPos( SB_HORZ, nPos );

		m_static_r.Format( "%i", clrkey.Red );

		UpdateData( FALSE );
	}

	if( pScrollBar->m_hWnd == m_scroll_g.m_hWnd )
	{
		clrkey.Green = nPos;

		ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

		BYTE threshold = clrkey.Threshold;

		pScrollBar->SetScrollPos( SB_HORZ, nPos );

		m_static_g.Format( "%i", clrkey.Green );

		UpdateData( FALSE );
	}

	if( pScrollBar->m_hWnd == m_scroll_b.m_hWnd )
	{
		clrkey.Blue = nPos;

		ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

		BYTE threshold = clrkey.Threshold;

		pScrollBar->SetScrollPos( SB_HORZ, nPos );

		m_static_b.Format( "%i", clrkey.Blue );

		UpdateData( FALSE );
	}

	if( pScrollBar->m_hWnd == m_scroll_threshold.m_hWnd )
	{
		clrkey.Threshold = nPos;

		ULONG colorkey = (clrkey.Blue << 16) + (clrkey.Green << 8) + (clrkey.Red << 0);

		BYTE threshold = clrkey.Threshold;

		pScrollBar->SetScrollPos( SB_HORZ, nPos );

		m_static_threshold.Format( "%i", clrkey.Threshold );

		UpdateData( FALSE );
	}
	LeaveCriticalSection(  &m_hShareRecordAccessCriticalSections[ 2 ] );
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}


void CColorKeyDlg::OnRadioFile() 
{
//
	nSelectType = 2;
	g_n_repeat_status = 1;

	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "MP4\0*.AVI;*.ASF;.MP4;*\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	if( strlen( psz ) > 0 ) {

		m_strFilePath = psz;

		if( m_pFile ) {

			QCAP_DESTROY_FILE( m_pFile );

			m_pFile = NULL;
		}

		QCAP_OPEN_FILE( psz, &m_pFile, QCAP_DECODER_TYPE_SOFTWARE, &m_nFileVideoFormat, &m_nFileVideoWidth, &m_nFileVideoHeight, &m_dFileVideoFrameRate, &m_nFileAudioFormat, &m_nFileAudioChannels, &m_nFileAudioBitsPerSample, &m_nFileAudioSampleFrequency, &m_dFileTotalDuationTimes, &m_nFileTotalVideoFrames, &m_nFileTotalAudioFrames, GetDlgItem( IDC_STATIC_FILE_DISPLAY )->m_hWnd, 1 );

		QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK( m_pFile, on_video_decoder_file_callback, this );

		QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK( m_pFile, on_audio_decoder_file_callback, this );

		QCAP_PAUSE_FILE( m_pFile );
	}

	QCAP_PLAY_FILE( m_pFile );

	SetTimer( 0x00000000,  10, NULL );

	EnterCriticalSection( &m_hShareRecordAccessCriticalSections[ 2 ] );

	m_nShareRecordState[ 2 ] = m_nShareRecordState[ 2 ] | (0x00000001 << 0);

	LeaveCriticalSection( &m_hShareRecordAccessCriticalSections[ 2 ] );

	GetDlgItem( IDC_RADIO_FILE  )->ShowWindow( TRUE );

	GetDlgItem( IDC_RADIO_SOURCE )->ShowWindow( FALSE );
}

BOOL CColorKeyDlg::PreTranslateMessage(MSG* pMsg)
{
	// TODO: Add your specialized code here and/or call the base class

	if( pMsg->message == WM_LBUTTONDBLCLK )
	{ 
		if ( pMsg->hwnd == GetDlgItem( IDC_STATIC_DISPLAY )->m_hWnd ) {

			CRect oWindowRect ; 

			if( m_isFullScreen == FALSE ) {

				GetDlgItem(IDC_STATIC_DISPLAY)->GetWindowRect(&m_old_window); 

				ScreenToClient(m_old_window);

				GetWindowRect(&oWindowRect);

				m_old = oWindowRect;

				SetParent(GetDesktopWindow()); 

				CRect rect; 

				GetDesktopWindow()-> GetWindowRect(&rect); 

				ModifyStyle(WS_CAPTION, 0, SWP_FRAMECHANGED); 

				SetWindowPos(&(CWnd::wndTop),rect.left,rect.top,rect.right,rect.bottom,SWP_SHOWWINDOW);

				m_isFullScreen = TRUE;

				GetDlgItem(IDC_STATIC_FORE_DISPLAY)->ShowWindow(FALSE);

				GetDlgItem(IDC_STATIC_BK_DISPLAY)->ShowWindow(FALSE);

				GetDlgItem(IDC_STATIC_FORMAT)->ShowWindow(FALSE);

				GetDlgItem(IDC_RADIO_SOURCE)->ShowWindow(FALSE);

				GetDlgItem(IDC_RADIO_FILE)->ShowWindow(FALSE);

				GetDlgItem(IDC_STATIC)->ShowWindow(FALSE);

				GetDlgItem(IDC_SLIDER_ALPHA)->ShowWindow(FALSE);

				GetDlgItem(IDC_SLIDER_R)->ShowWindow(FALSE);

				GetDlgItem(IDC_SLIDER_G)->ShowWindow(FALSE);

				GetDlgItem(IDC_SLIDER_B)->ShowWindow(FALSE);

				GetDlgItem(IDC_SLIDER_THRESHOLD)->ShowWindow(FALSE);

				GetDlgItem(IDC_STATIC_FILE_DISPLAY)->ShowWindow(FALSE);

				m_statWindow.SetParent(this);

				m_statWindow.SetWindowPos(&wndTop,rect.left,(rect.top),rect.right,(rect.bottom),SWP_SHOWWINDOW);
			}
			else {
			
				ShowWindow(TRUE);

				SetParent(this);

				ModifyStyle(0, WS_CAPTION, SWP_FRAMECHANGED);

				SetWindowPos(&wndTop, m_old.left, m_old.top, m_old.Width(), m_old.Height(), SWP_SHOWWINDOW);

				m_isFullScreen = FALSE;

				m_statWindow.SetWindowPos(&wndTop, m_old_window.left, m_old_window.top, m_old_window.Width(), m_old_window.Height(), SWP_SHOWWINDOW);

				GetDlgItem(IDC_STATIC_FORE_DISPLAY)->ShowWindow(TRUE);

				GetDlgItem(IDC_STATIC_BK_DISPLAY)->ShowWindow(TRUE);

				GetDlgItem(IDC_STATIC_FORMAT)->ShowWindow(TRUE);

				GetDlgItem(IDC_STATIC)->ShowWindow(TRUE);

				GetDlgItem(IDC_SLIDER_ALPHA)->ShowWindow(TRUE);

				GetDlgItem(IDC_SLIDER_R)->ShowWindow(TRUE);

				GetDlgItem(IDC_SLIDER_G)->ShowWindow(TRUE);

				GetDlgItem(IDC_SLIDER_B)->ShowWindow(TRUE);

				GetDlgItem(IDC_SLIDER_THRESHOLD)->ShowWindow(TRUE);

				GetDlgItem(IDC_STATIC_FILE_DISPLAY)->ShowWindow(TRUE);

				if ( nSelectType == 1 ) { GetDlgItem(IDC_RADIO_SOURCE)->ShowWindow(TRUE); }

				if ( nSelectType == 2 ) { GetDlgItem(IDC_RADIO_FILE)->ShowWindow(TRUE); }
			}
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}
