﻿
Imports QCAP.NET

Public Class MyVideoPropertyDlg

    Declare Function OutputDebugString Lib "kernel32" Alias "OutputDebugStringA" (ByVal message As String)

    Public m_pMainForm As MySetupControl

    Public m_hCapDev() As UInt32 = {0, 0, 0, 0}

    Private Sub MyVideoPropertyDlg_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub

    Private Sub MyVideoPropertyDlg_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

    End Sub

    Private Sub MyVideoPropertyDlg_Shown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Shown

        If m_hCapDev(0) <> 0 Then

            Dim nBrightness As UInt32 = 0

            EXPORTS.QCAP_GET_VIDEO_BRIGHTNESS(m_hCapDev(0), nBrightness)

            m_sliderBrightness.Value = nBrightness

            m_staticBrightness.Text = nBrightness.ToString()

            Dim nContrast As UInt32 = 0

            EXPORTS.QCAP_GET_VIDEO_CONTRAST(m_hCapDev(0), nContrast)

            m_sliderContrast.Value = nContrast

            m_staticContrast.Text = nContrast.ToString()

            Dim nHue As UInt32 = 0

            EXPORTS.QCAP_GET_VIDEO_HUE(m_hCapDev(0), nHue)

            m_sliderHue.Value = nHue

            m_staticHue.Text = nHue.ToString()

            Dim nSaturation As UInt32 = 0

            EXPORTS.QCAP_GET_VIDEO_SATURATION(m_hCapDev(0), nSaturation)

            m_sliderSaturation.Value = nSaturation

            m_staticSaturation.Text = nSaturation.ToString()

            Dim nSharpness As UInt32 = 0

            EXPORTS.QCAP_GET_VIDEO_SHARPNESS(m_hCapDev(0), nSharpness)

            m_sliderSharpness.Value = nSharpness

            m_staticSharpness.Text = nSharpness.ToString()

        End If

    End Sub

    Private Sub btnDefault_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDefault.Click

        EXPORTS.QCAP_SET_VIDEO_BRIGHTNESS(m_hCapDev(0), 128)

        EXPORTS.QCAP_SET_VIDEO_BRIGHTNESS(m_hCapDev(1), 128)

        EXPORTS.QCAP_SET_VIDEO_BRIGHTNESS(m_hCapDev(2), 128)

        EXPORTS.QCAP_SET_VIDEO_BRIGHTNESS(m_hCapDev(3), 128)

        m_sliderBrightness.Value = 128

        m_staticBrightness.Text = "128"

        EXPORTS.QCAP_SET_VIDEO_CONTRAST(m_hCapDev(0), 128)

        EXPORTS.QCAP_SET_VIDEO_CONTRAST(m_hCapDev(1), 128)

        EXPORTS.QCAP_SET_VIDEO_CONTRAST(m_hCapDev(2), 128)

        EXPORTS.QCAP_SET_VIDEO_CONTRAST(m_hCapDev(3), 128)

        m_sliderContrast.Value = 128

        m_staticContrast.Text = "128"

        EXPORTS.QCAP_SET_VIDEO_HUE(m_hCapDev(0), 128)

        EXPORTS.QCAP_SET_VIDEO_HUE(m_hCapDev(1), 128)

        EXPORTS.QCAP_SET_VIDEO_HUE(m_hCapDev(2), 128)

        EXPORTS.QCAP_SET_VIDEO_HUE(m_hCapDev(3), 128)

        m_sliderHue.Value = 128

        m_staticHue.Text = "128"

        EXPORTS.QCAP_SET_VIDEO_SATURATION(m_hCapDev(0), 128)

        EXPORTS.QCAP_SET_VIDEO_SATURATION(m_hCapDev(1), 128)

        EXPORTS.QCAP_SET_VIDEO_SATURATION(m_hCapDev(2), 128)

        EXPORTS.QCAP_SET_VIDEO_SATURATION(m_hCapDev(3), 128)

        m_sliderSaturation.Value = 128

        m_staticSaturation.Text = "128"

        EXPORTS.QCAP_SET_VIDEO_SHARPNESS(m_hCapDev(0), 128)

        EXPORTS.QCAP_SET_VIDEO_SHARPNESS(m_hCapDev(1), 128)

        EXPORTS.QCAP_SET_VIDEO_SHARPNESS(m_hCapDev(2), 128)

        EXPORTS.QCAP_SET_VIDEO_SHARPNESS(m_hCapDev(3), 128)

        m_sliderSharpness.Value = 128

        m_staticSharpness.Text = "128"

    End Sub

    Private Sub m_sliderBrightness_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_sliderBrightness.Scroll

        Dim n_property_value As UInt32 = m_sliderBrightness.Value

        m_staticBrightness.Text = n_property_value.ToString()

        If m_hCapDev(0) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_BRIGHTNESS(m_hCapDev(0), n_property_value)

        End If

        If m_hCapDev(1) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_BRIGHTNESS(m_hCapDev(1), n_property_value)

        End If

        If m_hCapDev(2) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_BRIGHTNESS(m_hCapDev(2), n_property_value)

        End If

        If m_hCapDev(3) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_BRIGHTNESS(m_hCapDev(3), n_property_value)

        End If

    End Sub

    Private Sub m_sliderContrast_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_sliderContrast.Scroll

        Dim n_property_value As UInt32 = m_sliderContrast.Value

        m_staticContrast.Text = n_property_value.ToString()

        If m_hCapDev(0) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_CONTRAST(m_hCapDev(0), n_property_value)

        End If

        If m_hCapDev(1) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_CONTRAST(m_hCapDev(1), n_property_value)

        End If

        If m_hCapDev(2) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_CONTRAST(m_hCapDev(2), n_property_value)

        End If

        If m_hCapDev(3) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_CONTRAST(m_hCapDev(3), n_property_value)

        End If

    End Sub

    Private Sub m_sliderHue_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_sliderHue.Scroll

        Dim n_property_value As UInt32 = m_sliderHue.Value

        m_staticHue.Text = n_property_value.ToString()

        If m_hCapDev(0) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_HUE(m_hCapDev(0), n_property_value)

        End If

        If m_hCapDev(1) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_HUE(m_hCapDev(1), n_property_value)

        End If

        If m_hCapDev(2) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_HUE(m_hCapDev(2), n_property_value)

        End If

        If m_hCapDev(3) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_HUE(m_hCapDev(3), n_property_value)

        End If

    End Sub

    Private Sub m_sliderSaturation_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_sliderSaturation.Scroll

        Dim n_property_value As UInt32 = m_sliderSaturation.Value

        m_staticSaturation.Text = n_property_value.ToString()

        If m_hCapDev(0) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_SATURATION(m_hCapDev(0), n_property_value)

        End If

        If m_hCapDev(1) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_SATURATION(m_hCapDev(1), n_property_value)

        End If

        If m_hCapDev(2) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_SATURATION(m_hCapDev(2), n_property_value)

        End If

        If m_hCapDev(3) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_SATURATION(m_hCapDev(3), n_property_value)

        End If

    End Sub

    Private Sub m_sliderSharpness_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_sliderSharpness.Scroll

        Dim n_property_value As UInt32 = m_sliderSharpness.Value

        m_staticSharpness.Text = n_property_value.ToString()

        If m_hCapDev(0) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_SHARPNESS(m_hCapDev(0), n_property_value)

        End If

        If m_hCapDev(1) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_SHARPNESS(m_hCapDev(1), n_property_value)

        End If

        If m_hCapDev(2) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_SHARPNESS(m_hCapDev(2), n_property_value)

        End If

        If m_hCapDev(3) <> 0 Then

            EXPORTS.QCAP_SET_VIDEO_SHARPNESS(m_hCapDev(3), n_property_value)

        End If

    End Sub

    Private Sub buttonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonOK.Click

        Hide()

    End Sub

End Class