// ChannelWindow.cpp : implementation file
//

#include "stdafx.h"
#include "MultiRecoderDemo.h"
#include "ChannelWindow.h"
#include "MultiRecoderDemodLG.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChannelWindow

CChannelWindow::CChannelWindow()
{
}

CChannelWindow::~CChannelWindow()
{
}


BEGIN_MESSAGE_MAP(CChannelWindow, CWnd)
	//{{AFX_MSG_MAP(CChannelWindow)
	ON_WM_ERASEBKGND()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChannelWindow message handlers

BOOL CChannelWindow::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	ULONG nChannelNum = GetDlgCtrlID();

	if ( (nChannelNum & 0xF0000000) == 0x00000000 ){ nChannelNum = nChannelNum & 0x000000FF; }		// DUE TO HAVING BACKGROUND AND FOREGROUND WINDOW

	if ( (nChannelNum & 0xF0000000) == 0x10000000 ){ nChannelNum = nChannelNum & 0x000000FF; }		// DUE TO HAVING BACKGROUND AND FOREGROUND WINDOW	

	// TO FILL IN THE TEXT 
	//
	CFont font_share;

	CFont font_live;

	ULONG nShareFontSize = 250;

	ULONG nLiveFontSize = 130;	

	font_share.CreatePointFont( nShareFontSize, TEXT("Arial"), NULL );

	font_live.CreatePointFont( nLiveFontSize, TEXT("Arial"), NULL );

	HFONT hOldFont;

	pDC->SetBkMode( TRANSPARENT );		
		
	pDC->SetTextColor( RGB( 255, 255, 255 ) );

	if ( (nChannelNum & 0xF0000000) == 0x30000000 ) {

		//Invalidate( 1 );

		hOldFont = (HFONT)pDC->SelectObject( &font_share );

		CRect rect_client;	GetClientRect( &rect_client );

		CBrush brush_fill_rect( RGB(0, 0, 0) );

		pDC->FillRect( &rect_client, &brush_fill_rect );

		CString string = TEXT("No Share Display");
		
		pDC->DrawText( string, &rect_client, DT_SINGLELINE | DT_CENTER | DT_VCENTER );		
		
		return TRUE;
	}

	if ( (nChannelNum & 0xF0000000) == 0x20000000 ) {

		CRect rect_client;	GetClientRect( &rect_client );

		CBrush brush_fill_rect( RGB(0, 0, 255) );

		pDC->FillRect( &rect_client, &brush_fill_rect );
		
		return TRUE;
	}

	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] == 0 ) {

		hOldFont = (HFONT)pDC->SelectObject( &font_live );

		CRect rect_client; GetClientRect( &rect_client );
		
		CBrush brush_fill_rect( RGB(0, 0, 0) );

		pDC->FillRect( &rect_client, &brush_fill_rect );
		
		CString string = TEXT("No Device");
		
		pDC->DrawText( string, &rect_client, DT_SINGLELINE | DT_CENTER | DT_VCENTER );

		return TRUE;
	}

	if ( pMainDlg->m_bNoSignal[ nChannelNum ] == 1 ) {

		hOldFont = (HFONT)pDC->SelectObject( &font_live );
		
		CRect rect_client; GetClientRect( &rect_client );

		CBrush brush_fill_rect( RGB(0, 0, 255) );

		pDC->FillRect( &rect_client, &brush_fill_rect );

		CString string = TEXT("No Source");
		
		pDC->DrawText( string, &rect_client, DT_SINGLELINE| DT_CENTER | DT_VCENTER );		
	}
	
	pDC->SelectObject( &hOldFont );

	font_share.DeleteObject();

	font_live.DeleteObject();
	
	return CWnd::OnEraseBkgnd(pDC);
}

void CChannelWindow::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	ULONG nChannelNum = GetDlgCtrlID();		
	
	// DRAG THE WINDOW
	//
	if ( (nChannelNum & 0xF0000000) == 0x30000000 ) {									// SHARE RECORDING WINDOW

		pMainDlg->PostMessage( 0x201, MAKELPARAM( point.x, point.y ) );

		return;
	}

	if ( (nChannelNum & 0x20000000) != 0x00000000 ){ return; }

	if ( (nChannelNum & 0x10000000) != 0x00000000 ){ nChannelNum = nChannelNum & 0x000000FF; }

	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] == 0 ) { return; }

	if ( pMainDlg->m_bNoSignal[ nChannelNum ] == 1 ) { return;}	

	for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ ) {

		if ( i == nChannelNum ) {

			CHAR szStr[ MAX_PATH ] = { 0 };
		
			pMainDlg->m_bShareRecordCH[ i ] = TRUE;				

			if ( !pMainDlg->m_nWndState ) { wsprintf( szStr, "%s ,  %s  CH%02d V", DEFAULT_PRODUCT, DEFAULT_PRODUCT_VERSION,  i + 1 ); pMainDlg->SetWindowText( szStr ); }				
		}
		else {
		
			pMainDlg->m_bShareRecordCH[ i ] = FALSE;
		}
	}

	pMainDlg->m_nShareDisplayChannelNumber = nChannelNum;

	pMainDlg->SetShareFormatChangedOutput_CShareRecord();

	CWnd::OnLButtonDown(nFlags, point);
}

void CChannelWindow::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	/*
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	ULONG nChannelNum = GetDlgCtrlID();

	if ( (nChannelNum & 0x20000000) != 0x00000000 ){ return; }

	if ( (nChannelNum & 0x10000000) != 0x00000000 ){ nChannelNum = nChannelNum & 0x000000FF; }

	pMainDlg->OnLButtonDblClk_ChannelWindow( nChannelNum, nFlags, point );
	
	  */
	CWnd::OnLButtonDblClk(nFlags, point);
}
