﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Threading;

using LibraryWrapper;

[StructLayout(LayoutKind.Sequential)]
public struct SYSTEMTIME
{
    public ushort wYear;
    public ushort wMonth;
    public ushort wDayOfWeek;
    public ushort wDay;
    public ushort wHour;
    public ushort wMinute;
    public ushort wSecond;
    public ushort wMilliseconds;
}

namespace SC510
{
    public partial class Form1 : Form
    {
        [DllImport("user32.dll")]
        public static extern uint FindWindow(string classname, string windowname);

        [DllImport("user32.dll")]
        public static extern uint SendMessage(uint hWnd, uint wMsg, uint wParam, uint lParam);

        [DllImport("user32.dll")]
        public static extern uint PostMessage(uint hWnd, uint wMsg, uint wParam, uint lParam);

        [DllImport("Kernel32.dll ")]
        public static extern void GetLocalTime(ref SYSTEMTIME sysTime);

        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        public uint m_nDisplayTabNumber = 0;  // 0 = LIVE / 1 = RECORD PLAYBACK / 2 = MAIN REALTIME PLAYBACK / 3 = SUB REALTIME PLAYBACK

        public uint m_nDeviceSerialNumber = 0; // DEVICE SERIAL NUMBER

        public uint[] m_hVideoDev = new uint[4]; // VIDEO STREAM CAPTURE DEVICE

        public uint[] m_hVideoEncoderDev = new uint[4];  // SOFTWARE H.264 ENCODER DEVICE                

        uint[] m_hAudioDev = new uint[4]; // AUDIO STREAM CAPTURE DEVICE

        uint[] m_hFileRendererDev = new uint[4]; // FILE RENDERER DEVICE

        uint[] m_nFileRendererRecordState = new uint[4]; // 0 = STOP / 1 = ACQUIRE / 2 = START

        public volatile bool[] m_bFileRendererChangeNotify = new bool[4]; // FILE.CHANGING.EVENT NOTIFY (0 = NONE / 1 = CHANGE)        

        public SYSTEMTIME[] m_sFileRendererChangeSystemTime = new SYSTEMTIME[4]; // FILE.CHANGING.EVENT SYSTEM TIME

        public string[] m_pFileRendererChangeDevName = new string[4]; // FILE.CHANGING.EVENT DEVICE NAME

        // CRITICAL SECTION OBJECT
        // 
        private Object thisLock = new Object();

        public uint[] m_hFileSourceDev = new uint[4]; // FILE SOURCE DEVICE

        uint m_hNetworkRendererDev; // FNETWORK RENDERER DEVICE

        uint[] m_nNetworkRendererStreamingState = new uint[4]; // 0 = STOP / 1 = ACQUIRE / 2 = START

        string m_strCurrentDir;  // CURRENT WORKING DIRECTORY

        // GET DEVICE PARAMETERS FROM SETUP DIALOG
        //        
        int std = 0;                                            // NTSC, PAL

        int[] cx = new int[8];                            // WIDTH

        int[] cy = new int[8];                            // HEIGHT

        double[] fps = new double[8];             // FRAME RATE

        int[] deinterlace = new int[8];              // DEONTERLACE

        int[] rcmode = new int[8];                   // VBR, CBR

        int[] bitrate = new int[8];                     // BITRATE

        int[] quality = new int[8];                   // QUALITY

        int[] gop = new int[8];                        // GOP

        int[] qpstep = new int[8];                   // QPSTEP

        int[] peakbitrate = new int[8];            // PEAKBITRATE

        int[] troughquality = new int[8];        // TROUGHQUALITY        

        // DATA STRUCTURE
        //
        EXPORTS.AMESDK_SECTION_INFO[] m_pSectionData = new EXPORTS.AMESDK_SECTION_INFO[4];

        EXPORTS.AMESDK_MOTION_INFO[] m_pMotionData = new EXPORTS.AMESDK_MOTION_INFO[4];

        EXPORTS.AMESDK_GPS_INFO[] m_pGpsData = new EXPORTS.AMESDK_GPS_INFO[4];

        EXPORTS.AMESDK_POS_INFO[] m_pPosData = new EXPORTS.AMESDK_POS_INFO[4];

        EXPORTS.AMESDK_FILE_INFO[] m_pFileInfo = new EXPORTS.AMESDK_FILE_INFO[4];

        // CALLBACK FUNCTION
        //
        EXPORTS.PF_BUFFER_CALLBACK m_pVideoBufferCB;

        EXPORTS.PF_BUFFER_CALLBACK m_pAudioBufferCB;        

        MyChannelControl[] m_cChannelControl_LIVE = new MyChannelControl[4]; // LIVE STREAM DISPLAY WINDOW

        MyChannelControl[] m_cChannelControl_FILE = new MyChannelControl[4]; // FILE STREAM DISPLAY WINDOW (RECORD PLAYBACK)               

        MySetupControl m_cSetupControl = new MySetupControl();

        public MyPeopertyDlg m_cPropertyDlg = new MyPeopertyDlg();

        public static string ByteArrayToString(byte[] array)
        {
            if (array == null)
            {
                throw new ArgumentNullException("array");
            }
            return Encoding.ASCII.GetString(array);
        }

        //  LIVE VIDEO CALLBACK FUNCTION
        //
        uint on_process_video_buffer(double dSampleTime, uint pBuffer, uint nBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nCH = pUserData;            

            uint bIsVisible = 0;

            bool bKeyFrame = (bIsKeyFrame == 1) ? true : false;

            bool bIsStreaming = (m_nNetworkRendererStreamingState[nCH] == 0x00000002) ? true : false;

            if (bKeyFrame)
            {
                if (m_nNetworkRendererStreamingState[nCH] == 0x00000001)
                {
                    // WAITING KEY FRAME

                    m_nNetworkRendererStreamingState[nCH] = 0x00000002; // TO GOTO START STATE

                    bIsStreaming = true;
                }
            }
            
            bool bIsRecord = false;

            if (m_nFileRendererRecordState[nCH] >= 0x00000002) { bIsRecord = true; }

            if (m_nFileRendererRecordState[nCH] >= 0x00000001)
            {
                SYSTEMTIME system_times = new SYSTEMTIME(); GetLocalTime(ref system_times);

                // ON 30 MINUTES TIMEOUT EVENT
                //
                if ((m_sFileRendererChangeSystemTime[nCH].wMinute < 30 && system_times.wMinute >= 30) || (m_sFileRendererChangeSystemTime[nCH].wMinute >= 30 && system_times.wMinute < 30) || (m_sFileRendererChangeSystemTime[nCH].wHour != system_times.wHour) || (m_sFileRendererChangeSystemTime[nCH].wDay != system_times.wDay) || (m_sFileRendererChangeSystemTime[nCH].wMonth != system_times.wMonth) || (m_sFileRendererChangeSystemTime[nCH].wYear != system_times.wYear))
                {
                    m_pFileRendererChangeDevName[nCH] = m_strCurrentDir + "\\RECORD" + nCH.ToString() + "_" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + ".AVI";

                    m_sFileRendererChangeSystemTime[nCH] = system_times;

                    m_bFileRendererChangeNotify[nCH] = true;
                }

                // CHANGE CURRENT RECORD FILE [FILE.CHANGING.EVENT]
                //
                if (m_bFileRendererChangeNotify[nCH] == true)
                {
                    uint n_video_color_space_type = 0;

                    uint n_video_frame_width = 0;

                    uint n_video_frame_height = 0;

                    uint n_video_frame_bit_count = 0;

                    double f_video_fps = 0.0;

                    uint dw_video_custom_flags = 0x00000000;

					uint n_audio_steam_type = 0;

                    uint n_audio_channels = 0;

                    uint n_audio_bit_per_sample = 0;

                    uint n_audio_samples_per_sec = 0;

                    // ENTER CRITICAL SECTION
                    //
                    lock (thisLock)
                    {
                        // CLOSE CURRENT RECORD FILE
                        //
                        if (m_hFileRendererDev[nCH] != 0xFFFFFFFF)
                        {
                            EXPORTS.AMESDK_FILE_GET_VIDEO_STREAM_FORMAT(m_hFileRendererDev[nCH], ref n_video_color_space_type, ref n_video_frame_width, ref n_video_frame_height, ref n_video_frame_bit_count, ref f_video_fps, ref dw_video_custom_flags);

                            EXPORTS.AMESDK_FILE_GET_AUDIO_STREAM_FORMAT(m_hFileRendererDev[nCH], ref n_audio_steam_type, ref n_audio_channels, ref n_audio_bit_per_sample, ref n_audio_samples_per_sec);

                            EXPORTS.AMESDK_DESTROY(m_hFileRendererDev[nCH]);

                            m_hFileRendererDev[nCH] = 0xFFFFFFFF;
                        }

                        // CREATE NEW RECORD FILE
                        //
                        m_hFileRendererDev[nCH] = EXPORTS.AMESDK_CREATE(ref m_pFileRendererChangeDevName[nCH], nCH, 3, 0, null, 0, 0, null, 0, 0, null, 0, 0, null, 0);

                        EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_FORMAT(m_hFileRendererDev[nCH], n_video_color_space_type, n_video_frame_width, n_video_frame_height, n_video_frame_bit_count, f_video_fps, dw_video_custom_flags);

                        EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_FORMAT(m_hFileRendererDev[nCH], n_audio_steam_type, n_audio_channels, n_audio_bit_per_sample, n_audio_samples_per_sec);

                        EXPORTS.AMESDK_PAUSE(m_hVideoEncoderDev[nCH]); // PUT THE ENCODER INTO STOP STATE
                    }
                    //
                    // LEAVE CRITICAL SECTION

                    m_bFileRendererChangeNotify[nCH] = false;
                }
            }

            EXPORTS.AMESDK_RUN(m_hVideoEncoderDev[nCH]); // PUT THE ENCODER INTO RUNNING STATE

            uint pDstStreamBuffer = 0, nDstStreamBufferLen = 0, bIsKeyFrame2 = 0;

            // SOFTWARE H.264 ENCODER
            //
            EXPORTS.AMESDK_CODEC_ENCODE(m_hVideoEncoderDev[nCH], pBuffer, 0x32595559, (uint)cx[nCH], (uint)cy[nCH], ref pDstStreamBuffer, ref nDstStreamBufferLen, ref bIsKeyFrame2, 0);

            if (bIsKeyFrame2 == 1)
            {
                m_nFileRendererRecordState[nCH] = 0x00000002;

                bIsRecord = true;
            }

            // RECORDING FILE
            //
            if (bIsRecord)
            {
                EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_BUFFER(m_hFileRendererDev[nCH], pDstStreamBuffer, nDstStreamBufferLen, bIsKeyFrame2, 0, 0, ref m_pSectionData[nCH], ref m_pMotionData[nCH], ref m_pGpsData[nCH], ref m_pPosData[nCH]);
            }

            // NETWORK STREAMING
            //            
            if (bIsStreaming)
            {
                uint n_buffer_queue_size = 0, n_frame_queue_size = 0, n_clients = 0;

                // CHECK CURRENT STATUS OF NETWORK CONNECTION                
                // 
                EXPORTS.AMESDK_NETWORK_GET_VIDEO_STREAM_STATISTICS(m_hNetworkRendererDev, nCH, ref n_buffer_queue_size, ref n_frame_queue_size, ref n_clients); // RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING

                // PUSH ONE VIDEO STREAM BUFFER INTO NETWORK
                //
                EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_BUFFER(m_hNetworkRendererDev, nCH, pDstStreamBuffer, nDstStreamBufferLen, bIsKeyFrame, 0, 0); // RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING            
            }

            if (m_nDisplayTabNumber == 0) { bIsVisible = 1; }

            return bIsVisible; // DISPLAY ON WINDOW
        }

        // AUDIO CALLBACK FUNCTION
        //
        uint on_process_audio_buffer(double dSampleTime, uint pBuffer, uint nBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nChannelNumber = pUserData;

            uint i = nChannelNumber;

            bool bIsStreaming = (m_nNetworkRendererStreamingState[i] == 0x00000002) ? true : false;

            uint bIsMute = 0;

            // ENTER CRITICAL SECTION
            //
            lock (thisLock)
            {
                bool bIsRecord = false;

                if (m_nFileRendererRecordState[i] >= 0x00000002) { bIsRecord = true; }

                if (bIsRecord)
                {
                    EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_BUFFER(m_hFileRendererDev[i], pBuffer, nBufferLen, 0, 0, ref m_pSectionData[i]);
                }
            }
            //
            // LEAVE CRITICAL SECTION

            if (bIsStreaming)
            {
                uint n_buffer_queue_size = 0, n_frame_queue_size = 0, n_clients = 0;

                // CHECK CURRENT STATUS OF NETWORK CONNECTION                
                // 
                EXPORTS.AMESDK_NETWORK_GET_AUDIO_STREAM_STATISTICS(m_hNetworkRendererDev, i, ref n_buffer_queue_size, ref n_frame_queue_size, ref n_clients); // RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING

                // PUSH ONE AUDIO STREAM BUFFER INTO NETWORK
                //
                EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_BUFFER(m_hNetworkRendererDev, i, pBuffer, nBufferLen, 0, 0); // RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING
            }

            if (m_nDisplayTabNumber == 0) { bIsMute = 1; }

            if (m_nDisplayTabNumber == 2) { bIsMute = 1; }

            return bIsMute;
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            uint i = 0;

            // USER INTERFACE PROGRAMMING (MAIN FORM)
            //
            System.Drawing.Size BorderSize = this.Size - this.ClientSize;

            this.Width = BorderSize.Width + 704;

            this.Height = BorderSize.Width + 480;

            for (i = 0; i < 4; i++)
            {
                m_cChannelControl_LIVE[i] = new MyChannelControl();

                m_cChannelControl_FILE[i] = new MyChannelControl();                                

                m_cChannelControl_LIVE[i].Parent = this;

                m_cChannelControl_FILE[i].Parent = this;
            }
            
             m_cChannelControl_LIVE[0].Left = 0;
             m_cChannelControl_LIVE[1].Left = 352;
             m_cChannelControl_LIVE[2].Left = 0;
             m_cChannelControl_LIVE[3].Left = 352;

             m_cChannelControl_FILE[0].Left = 0;            
             m_cChannelControl_FILE[1].Left = 352;                         
             m_cChannelControl_FILE[2].Left = 0;            
             m_cChannelControl_FILE[3].Left = 352;   
            
            m_cChannelControl_LIVE[0].Top = 0;
            m_cChannelControl_LIVE[1].Top = 0;
            m_cChannelControl_LIVE[2].Top = 240;
            m_cChannelControl_LIVE[3].Top = 240;

            m_cChannelControl_FILE[0].Top = 0;             
            m_cChannelControl_FILE[1].Top = 0;                         
            m_cChannelControl_FILE[2].Top = 240;                         
            m_cChannelControl_FILE[3].Top = 240; 

            for (i = 0; i < 4; i++)
            {
                m_cChannelControl_LIVE[i].Size = new System.Drawing.Size(352, 240);
                m_cChannelControl_FILE[i].Size = new System.Drawing.Size(352, 240);                                

                m_cChannelControl_LIVE[i].Visible = true;
                m_cChannelControl_FILE[i].Visible = false;                                

                m_cChannelControl_LIVE[i].m_nChannelNumber = i + 0x1000000;
                m_cChannelControl_FILE[i].m_nChannelNumber = i + 0x2000000;                                
            }

            SYSTEMTIME system_time = new SYSTEMTIME(); GetLocalTime(ref system_time);

            for (i = 0; i < 4; i++)
            {
                m_hVideoDev[i] = 0xFFFFFFFF;                

                m_hAudioDev[i] = 0xFFFFFFFF;

                m_hFileRendererDev[i] = 0xFFFFFFFF;

                m_nFileRendererRecordState[i] = 0;

                m_sFileRendererChangeSystemTime[i] = system_time;

                m_pFileRendererChangeDevName[i] = "";

                m_hFileSourceDev[i] = 0xFFFFFFFF;

                m_hNetworkRendererDev = 0xFFFFFFFF;

                m_nNetworkRendererStreamingState[i] = 0;
            }

            // CREATE CALLBACK FUNCTION
            // 
            m_pVideoBufferCB = new EXPORTS.PF_BUFFER_CALLBACK(on_process_video_buffer);

            m_pAudioBufferCB = new EXPORTS.PF_BUFFER_CALLBACK(on_process_audio_buffer);            
            //

            m_nDisplayTabNumber = 0;

            // USER INTERFACE PROGRAMMING (SETUP CONTROL)
            //
            m_cSetupControl = new MySetupControl();

            m_cPropertyDlg = new MyPeopertyDlg();            

            m_cSetupControl.m_pMainForm = this;

            m_cSetupControl.m_cFileManagerControl.m_pMainForm = this;

            m_cPropertyDlg.m_pMainForm = this;

            BorderSize = m_cSetupControl.Size - m_cSetupControl.ClientSize;

            this.Top = this.Top - 75;

            m_cSetupControl.Top = this.Bottom + 5;

            m_cSetupControl.Left = this.Left - ((1248 - 704 - BorderSize.Width) / 2);

            m_cSetupControl.Width = 0;

            m_cSetupControl.Height = 0;

            m_cSetupControl.Visible = false;

            m_cSetupControl.Show();

            m_cSetupControl.Visible = false;

            // GET CURRENT DIRECTORY
            //
            m_strCurrentDir = Directory.GetCurrentDirectory();

            HwInitialize();

            m_cSetupControl.Width = BorderSize.Width + 1248;

            m_cSetupControl.Height = BorderSize.Height + 25 * 12;

            m_cSetupControl.Visible = true; 
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            HwUninitialize();

            m_cSetupControl.Close();
        }

        public bool HwInitialize()
        {
            int i = 0;

            m_cSetupControl.GetStandardParameter(ref std);

            m_cSetupControl.GetResolutionParameter(ref cx, ref cy);

            m_cSetupControl.GetFrameRateParameter(ref fps);

            m_cSetupControl.GetDeinterlaceParameter(ref deinterlace);

            m_cSetupControl.GetRecordModeParameter(ref rcmode);

            m_cSetupControl.GetBitRateParameter(ref bitrate);

            m_cSetupControl.GetQualityParameter(ref quality);

            m_cSetupControl.GetGOPParameter(ref gop);

            m_cSetupControl.GetQPStepParameter(ref qpstep);

            m_cSetupControl.GetPeakBitRateParameter(ref peakbitrate);

            m_cSetupControl.GetTroughQualityParameter(ref troughquality);

            // INITIALIZE NETWORK RENDERERS (RTSP)
            //
            m_hNetworkRendererDev = 0xFFFFFFFF;

            string strNetworkRendererName = "Common Analog Network Renderer streams=4";

            m_hNetworkRendererDev = EXPORTS.AMESDK_CREATE(ref strNetworkRendererName, 0, 5, 0, null, 0, 0, null, 0, 0, null, 0, 0, null, 0);

            if ((m_hNetworkRendererDev & 0x80000000) == 0x80000000) { m_hNetworkRendererDev = 0xFFFFFFFF; }

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 0, 0x34363248, (uint)cx[0], (uint)cy[0], 24, fps[0], (uint)(bitrate[0] * 4));  // H264 = 0x34363248

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 1, 0x34363248, (uint)cx[1], (uint)cy[1], 24, fps[1], (uint)(bitrate[1] * 4));  // H264 = 0x34363248

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 2, 0x34363248, (uint)cx[2], (uint)cy[2], 24, fps[2], (uint)(bitrate[2] * 4));  // H264 = 0x34363248

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 3, 0x34363248, (uint)cx[3], (uint)cy[3], 24, fps[3], (uint)(bitrate[3] * 4));  // H264 = 0x34363248                        

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 0, 2, 16, 48000, 2 * 16 * 48000 * 4);  // HD / STEREO / 16BITS / 48000HZ

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 1, 2, 16, 48000, 2 * 16 * 48000 * 4);  // HD / STEREO / 16BITS / 48000HZ

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 2, 2, 16, 48000, 2 * 16 * 48000 * 4);  // HD / STEREO / 16BITS / 48000HZ

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 3, 2, 16, 48000, 2 * 16 * 48000 * 4);  // HD / STEREO / 16BITS / 48000HZ

            string strUserName = "root", strPassword = "root";

            EXPORTS.AMESDK_NETWORK_SET_USER_ACCOUNT(m_hNetworkRendererDev, ref strUserName, ref strPassword);

            EXPORTS.AMESDK_NETWORK_SET_STREAMING_PORT(m_hNetworkRendererDev, 554);

            // INITIALIZE FILE RENDERERS (AVI2.0)
            //
            SYSTEMTIME system_times = new SYSTEMTIME(); GetLocalTime(ref system_times);

            for (i = 0; i < 4; i++)
            {
                string file_path;

                m_sFileRendererChangeSystemTime[i] = system_times;

                file_path = @"Common Analog File Renderer C:\SC510\CH" + (i + 1).ToString("D2") + "\\" +
                                                                    system_times.wYear.ToString("D4") +
                                                                    system_times.wMonth.ToString("D2") +
                                                                    system_times.wDay.ToString("D2") +
                                                                    system_times.wHour.ToString("D2") +
                                                                    system_times.wMinute.ToString("D2") +
                                                                    system_times.wSecond.ToString("D2") + ".AVI";

                m_pFileRendererChangeDevName[i] = file_path;

                m_hFileRendererDev[i] = 0xFFFFFFFF;

                if (i == 0) { m_hFileRendererDev[0] = EXPORTS.AMESDK_CREATE(ref file_path, 0, 3, 0, null, 0); }

                if (i == 1) { m_hFileRendererDev[1] = EXPORTS.AMESDK_CREATE(ref file_path, 1, 3, 0, null, 0); }

                if (i == 2) { m_hFileRendererDev[2] = EXPORTS.AMESDK_CREATE(ref file_path, 2, 3, 0, null, 0); }

                if (i == 3) { m_hFileRendererDev[3] = EXPORTS.AMESDK_CREATE(ref file_path, 3, 3, 0, null, 0); }

                if ((m_hFileRendererDev[i] & 0x80000000) == 0x80000000) { m_hFileRendererDev[i] = 0xFFFFFFFF; }

                uint custom_flags = 0x00000000;

                EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_FORMAT(m_hFileRendererDev[i], 0x34363248, (uint)cx[i], (uint)cy[i], 24, fps[i], custom_flags); //H264 = 0x34363248

                EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_FORMAT(m_hFileRendererDev[i], 0x00000000, 2, 16, 48000);
            }

            // INITIALIZE VIDEO STREAMS (YUY2)
            //
            string strVideoChipName = "SA7160 PCI";

            for (i = 0; i < 4; i++)
            {
                m_hVideoDev[i] = 0xFFFFFFFF;

                if (i == 0) { m_hVideoDev[0] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 0, 0, (uint)m_cChannelControl_LIVE[0].Handle, m_pVideoBufferCB, 0, 0, null, 0, 0, null, 0, 0, null, 0); }

                if (i == 1) { m_hVideoDev[1] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 1, 0, (uint)m_cChannelControl_LIVE[1].Handle, m_pVideoBufferCB, 1, 0, null, 0, 0, null, 0, 0, null, 0); }

                if (i == 2) { m_hVideoDev[2] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 2, 0, (uint)m_cChannelControl_LIVE[2].Handle, m_pVideoBufferCB, 2, 0, null, 0, 0, null, 0, 0, null, 0); }

                if (i == 3) { m_hVideoDev[3] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 3, 0, (uint)m_cChannelControl_LIVE[2].Handle, m_pVideoBufferCB, 3, 0, null, 0, 0, null, 0, 0, null, 0); }

                if ((m_hVideoDev[i] & 0x80000000) == 0x80000000) { m_hVideoDev[i] = 0xFFFFFFFF; }
            }

            for (i = 0; i < 4; i++)
            {
                if ((std & 0x00000001) == 0x00000001)
                {
                    EXPORTS.AMESDK_SET_STANDARD(m_hVideoDev[i], 0x00000001); // NTSC = 0x00000001 / PAL = 0x00000010

                    EXPORTS.AMESDK_SET_FORMAT(m_hVideoDev[i], 0x32595559, (uint)cx[i], (uint)cy[i], 16, 29.97); // YUY2 = &H32595559

                    EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoDev[i], 0);
                }
                else
                {
                    EXPORTS.AMESDK_SET_STANDARD(m_hVideoDev[i], 0x00000010); // NTSC = 0x00000001 / PAL = 0x00000010

                    EXPORTS.AMESDK_SET_FORMAT(m_hVideoDev[i], 0x32595559, (uint)cx[i], (uint)cy[i], 16, 25.0); // YUY2 = &H32595559

                    EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoDev[i], 0);
                }

                if (i == 0) { EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev[0], 0, 0); }

                if (i == 1) { EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev[1], 0, 0); }

                if (i == 2) { EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev[2], 1, 0); }

                if (i == 3) { EXPORTS.AMESDK_SET_MIRROR(m_hVideoDev[3], 1, 0); }

                uint n_device_serial_number = 0;

                uint n_video_standard = 0;

                uint n_video_colorspace = 0;

                uint n_video_width = 0;

                uint n_video_height = 0;

                uint n_video_bitcount = 0;

                double d_video_framerate = 0;

                uint n_video_horizontal_mirror = 0;

                uint n_video_vertical_mirror = 0;

                EXPORTS.AMESDK_GET_CUSTOM_PROPERTY(m_hVideoDev[i], 0, ref n_device_serial_number);

                EXPORTS.AMESDK_GET_STANDARD(m_hVideoDev[i], ref n_video_standard);

                EXPORTS.AMESDK_GET_FORMAT(m_hVideoDev[i], ref n_video_colorspace, ref n_video_width, ref n_video_height, ref n_video_bitcount, ref d_video_framerate);

                EXPORTS.AMESDK_GET_MIRROR(m_hVideoDev[i], ref n_video_horizontal_mirror, ref n_video_vertical_mirror);

            }            

            // INITIALIZE AUDIO STREAMS (PCM)
            //
            string strAudioDev = "SA7160 PCI, Analog WaveIn";

            for (i = 0; i < 4; i++)
            {
                m_hAudioDev[i] = 0xFFFFFFFF;

                if (i == 0) { m_hAudioDev[0] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 0, 0, 0, m_pAudioBufferCB, 0); }

                if (i == 1) { m_hAudioDev[1] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 1, 0, 0, m_pAudioBufferCB, 1); }

                if (i == 2) { m_hAudioDev[2] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 3, 0, 0, m_pAudioBufferCB, 2); }

                if (i == 3) { m_hAudioDev[3] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 4, 0, 0, m_pAudioBufferCB, 3); }

                if ((m_hAudioDev[i] & 0x80000000) == 0x80000000) { m_hAudioDev[i] = 0xFFFFFFFF; }

                uint n_audio_channels = 0;

                uint n_audio_bits_per_sample = 0;

                uint n_audio_samples_per_sec = 0;

                EXPORTS.AMESDK_SET_FORMAT(m_hAudioDev[i], 2, 16, 48000); // STEREO/16BITS/48000HZ

                EXPORTS.AMESDK_GET_FORMAT(m_hAudioDev[i], ref n_audio_channels, ref n_audio_bits_per_sample, ref n_audio_samples_per_sec);
            }

            // SOFTWARE COMPRESSION
            //
            string strVideoEncoderDev = "Common Analog Encoder (H.264)";

            for (i = 0; i < 4; i++)
            {
                m_hVideoEncoderDev[i] = 0xFFFFFFFF;

                if (i == 0) { m_hVideoEncoderDev[0] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 0, 7, 0, null, 0, 0, null, 0, 0, null, 0, 0, null, 0);  }

                if (i == 1) { m_hVideoEncoderDev[1] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 1, 7, 0, null, 0, 0, null, 0, 0, null, 0, 0, null, 0); }

                if (i == 2) { m_hVideoEncoderDev[2] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 2, 7, 0, null, 0, 0, null, 0, 0, null, 0, 0, null, 0); }

                if (i == 3) { m_hVideoEncoderDev[3] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 3, 7, 0, null, 0, 0, null, 0, 0, null, 0, 0, null, 0); }

                if ((m_hVideoEncoderDev[i] & 0x80000000) == 0x80000000) { m_hVideoEncoderDev[i] = 0xFFFFFFFF; }
            }

            // SETUP SOFTWARE H.264 ENCODER PROPERTIES
            //      
            for (i = 0; i < 4; i++)
            {
                 if ((std & 0x00000001) == 0x00000001)
                {
                    EXPORTS.AMESDK_SET_FORMAT(m_hVideoEncoderDev[i], 0x34363248, (uint)cx[i], (uint)cy[i], 24, fps[i], (uint)rcmode[i], (uint)bitrate[i], (uint)quality[i], (uint)gop[i], 1, 0, 0);
                }
                else
                {
                    EXPORTS.AMESDK_SET_FORMAT(m_hVideoEncoderDev[i], 0x34363248, (uint)cx[i], (uint)cy[i], 24, fps[i], (uint)rcmode[i], (uint)bitrate[i], (uint)quality[i], (uint)gop[i], 1, 0, 0);
                }           
            }

            // GET DEVICE SERIAL NUMBER
            //  
            LibraryWrapper.EXPORTS.AMESDK_GET_CUSTOM_PROPERTY(m_hVideoDev[0], 0, ref m_nDeviceSerialNumber);

            // DEVICE RUN
            //
            EXPORTS.AMESDK_RUN(m_hVideoDev[0]);

            EXPORTS.AMESDK_RUN(m_hVideoDev[1]);

            EXPORTS.AMESDK_RUN(m_hVideoDev[2]);

            EXPORTS.AMESDK_RUN(m_hVideoDev[3]);            

            EXPORTS.AMESDK_RUN(m_hAudioDev[0]);

            EXPORTS.AMESDK_RUN(m_hAudioDev[1]);

            EXPORTS.AMESDK_RUN(m_hAudioDev[2]);

            EXPORTS.AMESDK_RUN(m_hAudioDev[3]);
            
            EXPORTS.AMESDK_RUN(m_hVideoEncoderDev[0]);

            EXPORTS.AMESDK_RUN(m_hVideoEncoderDev[1]);

            EXPORTS.AMESDK_RUN(m_hVideoEncoderDev[2]);

            EXPORTS.AMESDK_RUN(m_hVideoEncoderDev[3]);

            EXPORTS.AMESDK_RUN(m_hNetworkRendererDev);

            System.Threading.Thread.Sleep(512);

            // STRAT RECORDING
            //
            m_bFileRendererChangeNotify[0] = false;

            m_bFileRendererChangeNotify[1] = false;

            m_bFileRendererChangeNotify[2] = false;

            m_bFileRendererChangeNotify[3] = false;

            m_nFileRendererRecordState[0] = 1; // ACQUIRE RECORDING

            m_nFileRendererRecordState[1] = 1; // ACQUIRE RECORDING

            m_nFileRendererRecordState[2] = 1; // ACQUIRE RECORDING

            m_nFileRendererRecordState[3] = 1; // ACQUIRE RECORDING

            m_nNetworkRendererStreamingState[0] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

            m_nNetworkRendererStreamingState[1] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

            m_nNetworkRendererStreamingState[2] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

            m_nNetworkRendererStreamingState[3] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME            

            return true;
        }

        public bool HwUninitialize()
        {
            m_nNetworkRendererStreamingState[0] = 0; // STOP STREAMING

            m_nNetworkRendererStreamingState[1] = 0; // STOP STREAMING

            m_nNetworkRendererStreamingState[2] = 0; // STOP STREAMING

            m_nNetworkRendererStreamingState[3] = 0; // STOP STREAMING

            m_nFileRendererRecordState[0] = 0; // STOP RECORDING

            m_nFileRendererRecordState[1] = 0; // STOP RECORDING

            m_nFileRendererRecordState[2] = 0; // STOP RECORDING

            m_nFileRendererRecordState[3] = 0; // STOP RECORDING

            EXPORTS.AMESDK_STOP(m_hVideoDev[0]);

            EXPORTS.AMESDK_STOP(m_hVideoDev[1]);

            EXPORTS.AMESDK_STOP(m_hVideoDev[2]);

            EXPORTS.AMESDK_STOP(m_hVideoDev[3]);      

            EXPORTS.AMESDK_STOP(m_hAudioDev[0]);

            EXPORTS.AMESDK_STOP(m_hAudioDev[1]);

            EXPORTS.AMESDK_STOP(m_hAudioDev[2]);

            EXPORTS.AMESDK_STOP(m_hAudioDev[3]);

            EXPORTS.AMESDK_STOP(m_hVideoEncoderDev[0]);

            EXPORTS.AMESDK_STOP(m_hVideoEncoderDev[1]);

            EXPORTS.AMESDK_STOP(m_hVideoEncoderDev[2]);

            EXPORTS.AMESDK_STOP(m_hVideoEncoderDev[3]);

            uint i = 0;

            for (i = 0; i < 4; i++)
            {
                EXPORTS.AMESDK_DESTROY(m_hVideoDev[i]);                

                EXPORTS.AMESDK_DESTROY(m_hAudioDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hFileRendererDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hVideoEncoderDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hFileSourceDev[i]);

                m_hVideoDev[i] = 0xFFFFFFFF;                

                m_hAudioDev[i] = 0xFFFFFFFF;

                m_hFileRendererDev[i] = 0xFFFFFFFF;

                m_hVideoEncoderDev[i] = 0xFFFFFFFF;

                m_hFileSourceDev[i] = 0xFFFFFFFF;
            }

            EXPORTS.AMESDK_DESTROY(m_hNetworkRendererDev);

            m_hNetworkRendererDev = 0xFFFFFFFF;

            return true;
        }

        public void OnLButtonDown_ChannelControl(uint nChannelNumber)
        {
            if ((nChannelNumber & 0x1000000) == 0x1000000) // LIVE PATH
            {
                uint i = nChannelNumber - 0x1000000;

                if (m_cChannelControl_LIVE[i].Size.Height > 360)
                {
                    if (i == 0) { m_cChannelControl_LIVE[i].Left = 0; }
                    if (i == 1) { m_cChannelControl_LIVE[i].Left = 352; }
                    if (i == 2) { m_cChannelControl_LIVE[i].Left = 0; }
                    if (i == 3) { m_cChannelControl_LIVE[i].Left = 352; }
                    if (i == 0) { m_cChannelControl_LIVE[i].Top = 0; }
                    if (i == 1) { m_cChannelControl_LIVE[i].Top = 0; }
                    if (i == 2) { m_cChannelControl_LIVE[i].Top = 240; }
                    if (i == 3) { m_cChannelControl_LIVE[i].Top = 240; }

                    m_cChannelControl_LIVE[i].Size = new System.Drawing.Size(352, 240);

                    m_cChannelControl_LIVE[0].Visible = true;
                    m_cChannelControl_LIVE[1].Visible = true;
                    m_cChannelControl_LIVE[2].Visible = true;
                    m_cChannelControl_LIVE[3].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoDev[i]);
                }
                else
                {
                    m_cChannelControl_LIVE[i].Left = 0;
                    m_cChannelControl_LIVE[i].Top = 0;
                    m_cChannelControl_LIVE[i].Size = new System.Drawing.Size(704, 480);

                    m_cChannelControl_LIVE[0].Visible = false;
                    m_cChannelControl_LIVE[1].Visible = false;
                    m_cChannelControl_LIVE[2].Visible = false;
                    m_cChannelControl_LIVE[3].Visible = false;
                    m_cChannelControl_LIVE[i].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoDev[i]);
                }
            }

            if ((nChannelNumber & 0x2000000) == 0x2000000) // FILE STREAM PATH
            {
                uint i = nChannelNumber - 0x2000000;

                if (m_cChannelControl_FILE[i].Size.Height > 360)
                {
                    if (i == 0) { m_cChannelControl_FILE[i].Left = 0; }
                    if (i == 1) { m_cChannelControl_FILE[i].Left = 352; }
                    if (i == 2) { m_cChannelControl_FILE[i].Left = 0; }
                    if (i == 3) { m_cChannelControl_FILE[i].Left = 352; }
                    if (i == 0) { m_cChannelControl_FILE[i].Top = 0; }
                    if (i == 1) { m_cChannelControl_FILE[i].Top = 0; }
                    if (i == 2) { m_cChannelControl_FILE[i].Top = 240; }
                    if (i == 3) { m_cChannelControl_FILE[i].Top = 240; }

                    m_cChannelControl_FILE[i].Size = new System.Drawing.Size(352, 240);

                    m_cChannelControl_FILE[0].Visible = true;
                    m_cChannelControl_FILE[1].Visible = true;
                    m_cChannelControl_FILE[2].Visible = true;
                    m_cChannelControl_FILE[3].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hFileSourceDev[i]);
                }
                else
                {
                    m_cChannelControl_FILE[i].Left = 0;
                    m_cChannelControl_FILE[i].Top = 0;
                    m_cChannelControl_FILE[i].Size = new System.Drawing.Size(704, 480);

                    m_cChannelControl_FILE[0].Visible = false;
                    m_cChannelControl_FILE[1].Visible = false;
                    m_cChannelControl_FILE[2].Visible = false;
                    m_cChannelControl_FILE[3].Visible = false;
                    m_cChannelControl_FILE[i].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hFileSourceDev[i]);
                }
            }
        }

        public void OnCheckedChanged_RadioButton_SetupControl(uint nRadioButtonNumber)
        {
            m_nDisplayTabNumber = 0;

            if (nRadioButtonNumber == 0) // LIVE PATH
            {
                m_cChannelControl_LIVE[0].Visible = true;
                m_cChannelControl_LIVE[1].Visible = true;
                m_cChannelControl_LIVE[2].Visible = true;
                m_cChannelControl_LIVE[3].Visible = true;
                m_cChannelControl_FILE[0].Visible = false;
                m_cChannelControl_FILE[1].Visible = false;
                m_cChannelControl_FILE[2].Visible = false;
                m_cChannelControl_FILE[3].Visible = false;                                
            }

            if (nRadioButtonNumber == 1) // FILE STREAM PATH
            {
                m_cChannelControl_FILE[0].Visible = true;
                m_cChannelControl_FILE[1].Visible = true;
                m_cChannelControl_FILE[2].Visible = true;
                m_cChannelControl_FILE[3].Visible = true;
                m_cChannelControl_LIVE[0].Visible = false;
                m_cChannelControl_LIVE[1].Visible = false;
                m_cChannelControl_LIVE[2].Visible = false;
                m_cChannelControl_LIVE[3].Visible = false;                                
            }                        
        }        

        public bool OnFileSourceCreate_FileManagerWindow(uint nChannelNumber, ref EXPORTS.AMESDK_FILE_INFO pFileInfo)
        {            
            m_cSetupControl.GetDeinterlaceParameter(ref deinterlace);

            if (m_hFileSourceDev[nChannelNumber] == 0xFFFFFFFF)
            {
                string pszFileSourceName = @"Common Analog File Source " + ByteArrayToString(pFileInfo.m_pszFileName);// +Encoding.ASCII.GetString(pFileInfo.m_pszFileName.ToString());

                m_hFileSourceDev[nChannelNumber] = EXPORTS.AMESDK_CREATE(ref pszFileSourceName, nChannelNumber, 2, (uint)m_cChannelControl_FILE[nChannelNumber].Handle.ToInt32(), null, 0, 0, null, 0, 0, null, 0, 0, null, 0);

                if ((m_hFileSourceDev[nChannelNumber] & 0x80000000) == 0x80000000)
                {
                    m_hFileSourceDev[nChannelNumber] = 0xFFFFFFFF;
                }
            }

            return true;
        }

        public uint OnFileSourceRun_FileManagerWindow(uint nChannelNumber)
        {
            return EXPORTS.AMESDK_RUN(m_hFileSourceDev[nChannelNumber]);
        }

        public uint OnFileSourcePause_FileManagerWindow(uint nChannelNumber)
        {
            return EXPORTS.AMESDK_PAUSE(m_hFileSourceDev[nChannelNumber]);
        }

        public uint OnFileSourceStop_FileManagerWindow(uint nChannelNumber)
        {
            return EXPORTS.AMESDK_STOP(m_hFileSourceDev[nChannelNumber]);
        }

        public uint OnFileSourceStep_FileManagerWindow(uint nChannelNumber, uint nSteps)
        {
            return EXPORTS.AMESDK_STEP(m_hFileSourceDev[nChannelNumber], nSteps);
        }

        public uint OnFileSourceGetVideoStreamData_FileManagerWindow(uint nChannelNumber, uint nSample, ref UInt64 pTimeStamp, ref uint pIsKeyFrame )
        {
            return EXPORTS.AMESDK_FILE_GET_VIDEO_STREAM_DATA(m_hFileSourceDev[nChannelNumber], nSample, ref pTimeStamp, ref pIsKeyFrame);
        }

        public uint OnFileSourceGetAudioStreamData_FileManagerWindow(uint nChannelNumber, uint nSample, ref UInt64 pTimeStamp)
        {
            return EXPORTS.AMESDK_FILE_GET_AUDIO_STREAM_DATA(m_hFileSourceDev[nChannelNumber], nSample, ref pTimeStamp);
        }

        public long OnFileSourceGetMediaLength_FileManagerWindow(uint nChannelNumber, uint dwTimeUnits)
        {
            long nLength = 0;

            EXPORTS.AMESDK_FILE_GET_MEDIA_LENGTH(m_hFileSourceDev[nChannelNumber], ref nLength, dwTimeUnits);

            return nLength;
        }

        public uint OnFileSourceSetMediaPosition_FileManagerWindow(uint nChannelNumber, long nPosition, uint dwTimeUnits)
        {
            return EXPORTS.AMESDK_FILE_SET_MEDIA_POSITION(m_hFileSourceDev[nChannelNumber], nPosition, dwTimeUnits);
        }

        public double OnFileSourceGetMediaPlaybackRate_FileManagerWindow(uint nChannelNumber)
        {
            double dRate = 0.0;

            EXPORTS.AMESDK_FILE_GET_MEDIA_PLAYBACK_RATE(m_hFileSourceDev[nChannelNumber], ref dRate);

            return dRate;
        }

        public uint OnFileSourceSetMediaPlaybackRate_FileManagerWindow(uint nChannelNumber, double dRate)
        {
            return EXPORTS.AMESDK_FILE_SET_MEDIA_PLAYBACK_RATE(m_hFileSourceDev[nChannelNumber], dRate);
        }

        public void OnFileSourceDestroy_FileManagerWindow(uint nChannelNumber)
        {
            if (m_hFileSourceDev[nChannelNumber] != 0xFFFFFFFF)
            {
                EXPORTS.AMESDK_DESTROY(m_hFileSourceDev[nChannelNumber]);

                m_hFileSourceDev[nChannelNumber] = 0xFFFFFFFF;
            }
        }

        protected override void WndProc(ref Message m)
        {
            if (m.Msg == 0x00000014) // 0x00000014 = WM_ERASEBKGND
            {
                return;
            }

            if (m.Msg == 0x400) // 0x400 = WM_USER (UPDATE FILE INFO LIST)
            {
                DateTime system_time = DateTime.Now;

                DateTime start_search_system_time = new DateTime(system_time.Year, system_time.Month, system_time.Day);

                DateTime stop_search_system_time = new DateTime(system_time.Year, system_time.Month, system_time.Day, 23, 59, 59, 999);

                UInt64 n_start_search_systemtime = (UInt64)start_search_system_time.ToFileTimeUtc();

                UInt64 n_stop_search_systemtime = (UInt64)stop_search_system_time.ToFileTimeUtc();

                UInt32 i = (UInt32)m.WParam;

                string psz_search_directory = @"C:\\SC510\\CH" + (i + 1).ToString("D2") + "\\";

                uint nSearchProgress = 0, nRepairProgress = 0;

                EXPORTS.AMESDK_FILE_UPDATE_FILE_INFO_LIST(m_cSetupControl.m_cFileManagerControl.m_pFileInfoList[i], ref psz_search_directory, n_start_search_systemtime, n_stop_search_systemtime, 0, ref nSearchProgress, ref nRepairProgress); // 18446744073709551615 = &HFFFFFFFFFFFFFFFF

                m_cSetupControl.m_cFileManagerControl.Invalidate(true);
            }

            base.WndProc(ref m);
        }

    }
}
