#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <QmiService.h>
#include <CtlService.h>
#include <QmiSyncObject.h>
#include "lite-qmi-uim.h"
#include "uim.h"

typedef int (* pack_func) (pack_qmi_t*, uint8_t*, uint16_t*, void*);
typedef int (* unpack_func) (uint8_t*, uint16_t, void*);

#define pack_func_item pack_func* 
#define unpack_func_item unpack_func*
#define run_pack_item(x) ((pack_func) x)
#define run_unpack_item(x) ((unpack_func) x)

typedef struct
{
    pack_func_item   pack;
    char pack_func_name[128];
    void*       pack_ptr;
    unpack_func_item unpack;
    char unpack_func_name[128];
    void*       unpack_ptr;
} testitem_t;

enum eQCWWANError ExecuteUimTestCase(QmiService* pQmiService, testitem_t *pTestParams);

extern void DisplaySlotsStatus(unpack_uim_SLQSUIMGetSlotsStatus_t *pSlotStatus);
extern void DisplayVerifyPin(unpack_uim_VerifyPin_t *pVerifyPinResult);
extern void DisplayCardStatus(unpack_uim_GetCardStatus_t *pVerifyPinResult);
extern void DisplaySetPinProtection(unpack_uim_SetPinProtection_t *pSetPinProtection);
extern void DisplayUnblockPin(unpack_uim_UnblockPin_t *pUnblockPinResult);
extern void DisplayFileAttributes(unpack_uim_SLQSUIMGetFileAttributes_t *pGetFileAttributesResp);
extern void DisplayAuthenticate(unpack_uim_SLQSUIMAuthenticate_t *pAuthenticateResp);
extern void DisplayConfiguration(unpack_uim_SLQSUIMGetConfiguration_t *pGetConfigurationResp);
extern void DisplayChangePin(unpack_uim_ChangePin_t *pChangePinResp);
extern void DisplayGetLastEvent(unpack_uim_SLQSUIMRefreshGetLastEvent_t *pRefreshGetLastEventResp);
extern void DisplayGetFileAttributesInd(unpack_uim_SLQSUIMGetFileAttibutes_Ind_t *pGetFileAttributesInd);
extern void DisplaySlotStatusChangeInd(unpack_uim_SetUimSlotStatusChangeCallback_ind_t *pSlotStatusChangeCallback_ind);

void ReadTransparent2(QmiService* pQmiService);

void GetSlotsStatus(QmiService* pQmiService)
{
    testitem_t testItem;
    slots_t UimSlotsStatus[3];
    uint8_t    NumberOfPhySlot = sizeof(UimSlotsStatus)/sizeof(slots_t);
    unpack_uim_SLQSUIMGetSlotsStatus_t slotStatus = {&NumberOfPhySlot, UimSlotsStatus, SWI_UINT256_INT_VALUE} ;

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMGetSlotsStatus;
    strcpy(testItem.pack_func_name, "uim_SLQSUIMGetSlotsStatus");
    testItem.pack_ptr = NULL;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMGetSlotsStatus;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMGetSlotsStatus");
    testItem.unpack_ptr = &slotStatus;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
        DisplaySlotsStatus(&slotStatus);
}

void GetCardStatus(QmiService* pQmiService)
{
    testitem_t testItem;
    uim_cardStatus CardStatus;
    uim_hotSwapStatus HotSwapStatus;
    unpack_uim_GetCardStatus_t getCardStatus = {&CardStatus,&HotSwapStatus,0, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_GetCardStatus;
    strcpy(testItem.pack_func_name, "pack_uim_GetCardStatus");
    testItem.pack_ptr = NULL;
    testItem.unpack = (unpack_func_item) &unpack_uim_GetCardStatus;
    strcpy(testItem.unpack_func_name, "unpack_uim_GetCardStatus");
    testItem.unpack_ptr = &getCardStatus;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
       DisplayCardStatus(&getCardStatus);
   }
}

void GetIccid(QmiService* pQmiService)
{
    testitem_t testItem;
    uint8_t ICCIDLength = 255;
    uint8_t activeICCID[255] = {0};
    unpack_uim_SLQSUIMGetIccid_t getICCID = {&ICCIDLength, activeICCID};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMGetIccid;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMGetIccid");
    testItem.pack_ptr = NULL;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMGetIccid;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMGetIccid");
    testItem.unpack_ptr = &getICCID;

    if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
    {
        if ((getICCID.bICCIDLength))
        {
            printf("\nICCID: ");
            for (uint8_t i = 0; i < *(getICCID.bICCIDLength); i ++)
                printf("%c", getICCID.bICCID[i]);

            printf("\n");
        }
   }
}

void EventRegister(QmiService* pQmiService, uint32_t mask)
{
    testitem_t testItem;
    pack_uim_SLQSUIMEventRegister_t eventRegister = {mask};
    unpack_uim_SLQSUIMEventRegister_t eventRegisterResult;

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMEventRegister;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMEventRegister");
    testItem.pack_ptr = &eventRegister;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMEventRegister;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMEventRegister");
    testItem.unpack_ptr = &eventRegisterResult;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
        printf("\n");
        swi_uint256_print_mask (eventRegisterResult.ParamPresenceMask);
        if(swi_uint256_get_bit (eventRegisterResult.ParamPresenceMask, 16))
            printf("event mask returned 0x%04X\n", eventRegisterResult.eventMask);
   }
}

void SwitchSlot(QmiService* pQmiService, uint8_t logical_slot, uint8_t physical_slot)
{
    testitem_t testItem;
    pack_uim_SLQSUIMSwitchSlot_t switchSlotIn = {logical_slot, physical_slot};
    unpack_uim_SLQSUIMSwitchSlot_t switchSlotOut = {0, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMSwitchSlot;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMSwitchSlot");
    testItem.pack_ptr = &switchSlotIn;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMSwitchSlot;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMSwitchSlot");
    testItem.unpack_ptr = &switchSlotOut;

    if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
    {
        swi_uint256_print_mask (switchSlotOut.ParamPresenceMask);
        if(swi_uint256_get_bit (switchSlotOut.ParamPresenceMask, 2))
            printf("\n%s Result: %s\n",__FUNCTION__, switchSlotOut.Tlvresult==0? "Succeeded" : "Failed");
    }
}

void VerifyPin(QmiService* pQmiService, pack_uim_VerifyPin_t *pVerifyPin)
{
    testitem_t testItem;

    uim_remainingRetries RemainingRetries;
    uim_encryptedPIN1    EncryptedPIN1;
    uint32_t             IndicationToken;
    unpack_uim_VerifyPin_t verifyPinResult ={&RemainingRetries,&EncryptedPIN1,&IndicationToken,0, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_VerifyPin;
    strcpy(testItem.pack_func_name, "pack_uim_VerifyPin");
    testItem.pack_ptr = pVerifyPin;
    testItem.unpack = (unpack_func_item) &unpack_uim_VerifyPin;
    strcpy(testItem.unpack_func_name, "unpack_uim_VerifyPin");
    testItem.unpack_ptr = &verifyPinResult;

   ExecuteUimTestCase(pQmiService, &testItem);
   DisplayVerifyPin(&verifyPinResult);
}

void SetPinProtection(QmiService* pQmiService, pack_uim_SetPinProtection_t *pRetPinProtectionReq)
{
    testitem_t testItem;

    uint32_t IndicationToken = 5;
    uim_remainingRetries RemainingRetries;
    uim_encryptedPIN1    EncryptedPIN1;
    unpack_uim_SetPinProtection_t setPinProtection = {&RemainingRetries,&EncryptedPIN1,&IndicationToken,0, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SetPinProtection;
    strcpy(testItem.pack_func_name, "pack_uim_SetPinProtection");
    testItem.pack_ptr = pRetPinProtectionReq;
    testItem.unpack = (unpack_func_item) &unpack_uim_SetPinProtection;
    strcpy(testItem.unpack_func_name, "unpack_uim_SetPinProtection");
    testItem.unpack_ptr = &setPinProtection;

   ExecuteUimTestCase(pQmiService, &testItem);
   DisplaySetPinProtection(&setPinProtection);
}

void UnblockPin(QmiService* pQmiService, pack_uim_UnblockPin_t *pUnblockPinReq)
{
    testitem_t testItem;
    uim_remainingRetries RemainingRetries;
    uim_encryptedPIN1    EncryptedPIN1;
    uint32_t             IndicationToken;
    unpack_uim_UnblockPin_t unblockPinResult = {&RemainingRetries,&EncryptedPIN1,&IndicationToken,0, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_UnblockPin;
    strcpy(testItem.pack_func_name, "pack_uim_UnblockPin");
    testItem.pack_ptr = pUnblockPinReq;
    testItem.unpack = (unpack_func_item) &unpack_uim_UnblockPin;
    strcpy(testItem.unpack_func_name, "unpack_uim_UnblockPin");
    testItem.unpack_ptr = &unblockPinResult;

   ExecuteUimTestCase(pQmiService, &testItem);
   DisplayUnblockPin(&unblockPinResult);
}

void PowerDown(QmiService* pQmiService)
{
    testitem_t testItem;
    pack_uim_SLQSUIMPowerDown_t powerDownReq ={1};
    unpack_uim_SLQSUIMPowerDown_t powerDownResult = {0, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMPowerDown;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMPowerDown");
    testItem.pack_ptr = &powerDownReq;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMPowerDown;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMPowerDown");
    testItem.unpack_ptr = &powerDownResult;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
        swi_uint256_print_mask (powerDownResult.ParamPresenceMask);
        if(swi_uint256_get_bit (powerDownResult.ParamPresenceMask, 2))
            printf("\n%s Result: %s\n",__FUNCTION__, powerDownResult.Tlvresult==0? "Succeeded" : "Failed");
   }
}

void PowerUp(QmiService* pQmiService)
{
    testitem_t testItem;
    uint8_t bCheckHotSwapSwitch = 0;
    pack_uim_SLQSUIMPowerUp_t   powerUpReq = {1,&bCheckHotSwapSwitch};
    unpack_uim_SLQSUIMPowerUp_t powerUpResult = {0, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMPowerUp;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMPowerUp");
    testItem.pack_ptr = &powerUpReq;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMPowerUp;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMPowerUp");
    testItem.unpack_ptr = &powerUpResult;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
        swi_uint256_print_mask (powerUpResult.ParamPresenceMask);
        if(swi_uint256_get_bit (powerUpResult.ParamPresenceMask, 2))
            printf("\n%s Result: %s\n",__FUNCTION__, powerUpResult.Tlvresult==0? "Succeeded" : "Failed");
   }
}

void Reset(QmiService* pQmiService)
{
    testitem_t testItem;
    unpack_uim_SLQSUIMReset_t resetResult = {0, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMReset;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMReset");
    testItem.pack_ptr = NULL;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMReset;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMReset");
    testItem.unpack_ptr = &resetResult;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
        swi_uint256_print_mask (resetResult.ParamPresenceMask);
        if(swi_uint256_get_bit (resetResult.ParamPresenceMask, 2))
            printf("\n%s Result: %s\n",__FUNCTION__, resetResult.Tlvresult==0? "Succeeded" : "Failed");
   }
}

void RefreshOK(QmiService* pQmiService, pack_uim_SLQSUIMRefreshOK_t *pRefreshOK)
{
    testitem_t testItem;
    unpack_uim_SLQSUIMRefreshOK_t refreshOKResult = {0, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMRefreshOK;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMRefreshOK");
    testItem.pack_ptr = pRefreshOK;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMRefreshOK;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMRefreshOK");
    testItem.unpack_ptr = &refreshOKResult;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
        swi_uint256_print_mask (refreshOKResult.ParamPresenceMask);
        if(swi_uint256_get_bit (refreshOKResult.ParamPresenceMask, 2))
            printf("\n%s Result: %s\n",__FUNCTION__, refreshOKResult.Tlvresult==0? "Succeeded" : "Failed");
   }
}

void RefreshRegister(QmiService* pQmiService, pack_uim_SLQSUIMRefreshRegister_t *pRefreshRegister)
{
    testitem_t testItem;
    unpack_uim_SLQSUIMRefreshRegister_t refreshRegisterResult = {0, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMRefreshRegister;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMRefreshRegister");
    testItem.pack_ptr = pRefreshRegister;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMRefreshRegister;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMRefreshRegister");
    testItem.unpack_ptr = &refreshRegisterResult;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
        swi_uint256_print_mask (refreshRegisterResult.ParamPresenceMask);
        if(swi_uint256_get_bit (refreshRegisterResult.ParamPresenceMask, 2))
            printf("\n%s Result: %s\n",__FUNCTION__, refreshRegisterResult.Tlvresult==0? "Succeeded" : "Failed");
   }
}

void RefreshComplete(QmiService* pQmiService, pack_uim_SLQSUIMRefreshComplete_t *pRefreshComplete)
{
    testitem_t testItem;
    unpack_uim_SLQSUIMRefreshComplete_t refreshCompleteResult = {0, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMRefreshComplete;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMRefreshComplete");
    testItem.pack_ptr = pRefreshComplete;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMRefreshComplete;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMRefreshComplete");
    testItem.unpack_ptr = &refreshCompleteResult;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
        swi_uint256_print_mask (refreshCompleteResult.ParamPresenceMask);
        if(swi_uint256_get_bit (refreshCompleteResult.ParamPresenceMask, 2))
            printf("\n%s Result: %s\n",__FUNCTION__, refreshCompleteResult.Tlvresult==0? "Succeeded" : "Failed");
   }
}

void RfreshGetLastEvent(QmiService* pQmiService, pack_uim_SLQSUIMRefreshGetLastEvent_t *pRefreshGetLastEventReq)
{
    testitem_t testItem;

    uim_refreshevent refreshEvent;
    unpack_uim_SLQSUIMRefreshGetLastEvent_t refreshGetLastEventResp={&refreshEvent, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMRefreshGetLastEvent;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMRefreshGetLastEvent");
    testItem.pack_ptr = pRefreshGetLastEventReq;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMRefreshGetLastEvent;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMRefreshGetLastEvent");
    testItem.unpack_ptr = &refreshGetLastEventResp;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
       DisplayGetLastEvent(&refreshGetLastEventResp);
   }
}

void GetFileAttributes(QmiService* pQmiService, pack_uim_SLQSUIMGetFileAttributes_t *pGetFileAttributesReq)
{
    testitem_t testItem;

    uim_cardResult     cardresult;
    uim_fileAttributes fileattributes;
    uint32_t           indicationtoken;
    uint32_t           fileStatus;
    unpack_uim_SLQSUIMGetFileAttributes_t getFileAttributesResp = { &cardresult, &fileattributes, &indicationtoken, &fileStatus, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMGetFileAttributes;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMGetFileAttributes");
    testItem.pack_ptr = pGetFileAttributesReq;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMGetFileAttributes;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMGetFileAttributes");
    testItem.unpack_ptr = &getFileAttributesResp;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
       DisplayFileAttributes(&getFileAttributesResp);
   }
}

void Depersonalization(QmiService* pQmiService)      
{
    testitem_t testItem;
    uim_remainingRetries remainingRtries;
    pack_uim_SLQSUIMDepersonalization_t depersonalizationReq = {{ 0x00, 0x00, 0x06, "000000" }};//This parameter de-activates the depersonalization information
    unpack_uim_SLQSUIMDepersonalization_t depersonalizationResp = {&remainingRtries, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMDepersonalization;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMDepersonalization");
    testItem.pack_ptr = &depersonalizationReq;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMDepersonalization;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMDepersonalization");
    testItem.unpack_ptr = &depersonalizationResp;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
       swi_uint256_print_mask (depersonalizationResp.ParamPresenceMask);
       if (( NULL != depersonalizationResp.pRemainingRetries ) && (swi_uint256_get_bit (depersonalizationResp.ParamPresenceMask, 16)))
       {
           printf( "SLQSUIMDepersonalization Unsuccessful\n");
           printf( "Verify Left  :%d\n", depersonalizationResp.pRemainingRetries->verifyLeft );
           printf( "Unblock Left :%d\n", depersonalizationResp.pRemainingRetries->unblockLeft );
       }
       else
           printf( "Depersonalization is Successful\n");
   }
}

void Authenticate(QmiService* pQmiService)
{
    testitem_t testItem;
    uint32_t indicationTokenReq = 5;
    pack_uim_SLQSUIMAuthenticate_t authenticateReq = { { 0x00, 0x00, "" }, //session type - Primary GW provisioning
                                                       { 0x00, 0x04, "1234" }, //UIM Authenticate parameters
                                                        &indicationTokenReq
                                                     };
    uim_cardResult          cardrsult;
    uim_authenticateResult  authenticateresult;
    uint32_t                indicationToken;
    unpack_uim_SLQSUIMAuthenticate_t authenticateResp = {&cardrsult, &authenticateresult, &indicationToken, SWI_UINT256_INT_VALUE};

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMAuthenticate;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMAuthenticate");
    testItem.pack_ptr = &authenticateReq;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMAuthenticate;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMAuthenticate");
    testItem.unpack_ptr = &authenticateResp;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
       DisplayAuthenticate(&authenticateResp);
   }
}

void GetConfiguration(QmiService* pQmiService, uint32_t mask)
{
    testitem_t testItem;

    uint8_t autoSelection = 0xFF;
    pack_uim_SLQSUIMGetConfiguration_t getConfigurationReq = {&mask};
    unpack_uim_SLQSUIMGetConfiguration_t getConfigurationResp = { &autoSelection,
                                                                  NULL,
                                                                  NULL,
                                                                  SWI_UINT256_INT_VALUE
                                                                };//Automatic Selection"

    testItem.pack = (pack_func_item) &pack_uim_SLQSUIMGetConfiguration;
    strcpy(testItem.pack_func_name, "pack_uim_SLQSUIMGetConfiguration");
    testItem.pack_ptr = &getConfigurationReq;
    testItem.unpack = (unpack_func_item) &unpack_uim_SLQSUIMGetConfiguration;
    strcpy(testItem.unpack_func_name, "unpack_uim_SLQSUIMGetConfiguration");
    testItem.unpack_ptr = &getConfigurationResp;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
       DisplayConfiguration(&getConfigurationResp);
   }
}

void ChangePin(QmiService* pQmiService, pack_uim_ChangePin_t *pChangePin)
{
    testitem_t testItem;

    uint32_t IndicationToken = 5;
    /*uint8_t KeyReferenceID  = 1;
    pack_uim_ChangePin_t changePinReq = {{4,"1234"},&IndicationToken, &KeyReferenceID, { 0x00, 0x01, "1" },
                                         { 0x01, 0x04, "1234", 0x04, "0000" }, 1};*/

    uim_remainingRetries RemainingRetries;
    uim_encryptedPIN1    EncryptedPIN1;
    unpack_uim_ChangePin_t changePinResp = {&RemainingRetries, &EncryptedPIN1, &IndicationToken,1, SWI_UINT256_INT_VALUE };

    testItem.pack = (pack_func_item) &pack_uim_ChangePin;
    strcpy(testItem.pack_func_name, "pack_uim_ChangePin");
    testItem.pack_ptr = pChangePin;
    testItem.unpack = (unpack_func_item) &unpack_uim_ChangePin;
    strcpy(testItem.unpack_func_name, "unpack_uim_ChangePin");
    testItem.unpack_ptr = &changePinResp;

   ExecuteUimTestCase(pQmiService, &testItem);
   DisplayChangePin(&changePinResp);
}

typedef struct {
 char szICCID[UIM_UINT8_MAX_STRING_SZ];
 uint8_t szPUK[UIM_UINT8_MAX_STRING_SZ];
}iccid_puk;

pack_uim_UnblockPin_t UnblockPinReq={
    {0,{0}}, //uim_encryptedPIN1    EncryptedPIN1;
    NULL,//  &IndicationToken,//uint32_t IndicationToken;
    NULL,
    { 0x00, 0x01, "1" },//uim_sessionInformation sessionInfo;
    { 0x01, 0x08, "52075361", 0x04, "1234" },//Smartone LTE SIM (RED)
    //{ 0x01, 0x08, "64159849", 0x04, "1234" },//Smartone 3G SIM (WHITE)
    //{ 0x01, 0x08, "20624355", 0x04, "1234" },//Three LTE SIM
    //{ 0x01, 0x08, "79915593", 0x04, "1234" },//Three 3G SIM
    0//uint16_t Tlvresult;
};

void change_default_puk(char *ICCIDString, uint16_t uLength)
{
    iccid_puk sims[]={
       {"","88456232"},//Smartone LTE SIM (RED)
       {"8985203000049613960f","64159849"},//Smartone 3G SIM (WHITE)
       {"8985203000057115684f","20624355"},//Three LTE SIM
       {"8985203000049613960f","79915593"},//Three 3G SIM
       {"89852061012131090341","64159849"}
    };
    int i = 0;
    printf("ICCID:%s\n",ICCIDString);
    for(i=0;i<(int)(sizeof(sims)/sizeof(iccid_puk));i++)
    {
        if((int)strlen(sims[i].szICCID)==(int)uLength)
        {
            int j =0;
            for(j=0;j<(int)strlen(sims[i].szICCID);j++)
            {
               if(sims[i].szICCID[j]!=ICCIDString[j])
               {
                  break;
               }
            }
            if (j==(int)strlen(sims[i].szICCID))
            {
               for(j=0;j<8;j++)
               UnblockPinReq.pinProtection.pukVal[j]=sims[i].szPUK[j];
               printf("ICCID:%s,",sims[i].szICCID);
               printf("PUK:%s\n",sims[i].szPUK);
               return ;
            }
        }
    }
}

void ReadTransparent(QmiService* pQmiService)
{
    testitem_t testItem;

    /* UIM_READ_TRANSPARENT :This parameter contains the file information for ICCID Elementary File */
    uim_UIMSessionInformation sessionInfo_ICCID = { 0x00, 0x00, "" };
    uim_fileInfo             fileEF_ICCID  = { 0x2FE2, 0x02, {0x3F00} };
    uim_readTransparentInfo  readtp_ICCID   = { 0, 0 };

    uim_cardResult   CardResult;
    uim_readResult   ReadResult;
    uint32_t        IndicationToken = 0xffffffff;
    uint8_t         EncryptedData = 0xff;

    pack_uim_ReadTransparent_t req;
    unpack_uim_ReadTransparent_t readTransparent;
    uint16_t count;

    memset(&req,0,sizeof(req));
    memset(&readTransparent,0,sizeof(readTransparent));

    memset(&CardResult,0,sizeof(CardResult));
    memset(&ReadResult,0,sizeof(ReadResult));

    memcpy(&(req.sessionInfo),&sessionInfo_ICCID,sizeof(uim_UIMSessionInformation));
    memcpy(&(req.fileIndex),&fileEF_ICCID,sizeof(uim_fileInfo));
    memcpy(&(req.readTransparent),&readtp_ICCID,sizeof(uim_readTransparentInfo));   
    req.pIndicationToken = NULL;
    req.pEncryptData     = NULL;

    readTransparent.pCardResult      = &CardResult;
    readTransparent.pEncryptedData   = &EncryptedData;
    readTransparent.pIndicationToken = &IndicationToken;
    readTransparent.pReadResult      = &ReadResult;


    testItem.pack = (pack_func_item) &pack_uim_ReadTransparent;
    strcpy(testItem.pack_func_name, "pack_uim_ReadTransparent");
    testItem.pack_ptr = &req;
    testItem.unpack = (unpack_func_item) &unpack_uim_ReadTransparent;
    strcpy(testItem.unpack_func_name, "unpack_uim_ReadTransparent");
    testItem.unpack_ptr = &readTransparent;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
        swi_uint256_print_mask (readTransparent.ParamPresenceMask);
        if (( NULL != readTransparent.pCardResult ) && (swi_uint256_get_bit (readTransparent.ParamPresenceMask, 16)))
        {
            printf("\n  SW1 received from card :%x\n", readTransparent.pCardResult->sw1 );
            printf("  SW2 received from card :%x\n", readTransparent.pCardResult->sw2 );
        }

        if (( NULL != readTransparent.pReadResult) && (swi_uint256_get_bit (readTransparent.ParamPresenceMask, 17)))
        {
            char szcontent[UIM_UINT8_MAX_STRING_SZ]={0};
            printf("   ICCID No: ");
            for(count=0; count < readTransparent.pReadResult->contentLen; count++)
            {
                printf("%x",readTransparent.pReadResult->content[count] & 0x0f);
                printf("%x", (readTransparent.pReadResult->content[count]>>4) & 0x0f);
                sprintf(szcontent+count*2,"%x%x",readTransparent.pReadResult->content[count] & 0x0f,(readTransparent.pReadResult->content[count]>>4) & 0x0f);
            }
            printf("\n   ");
            change_default_puk(szcontent, readTransparent.pReadResult->contentLen*2);
        }
   }

   ReadTransparent2(pQmiService);
}

void ReadTransparent2(QmiService* pQmiService)
{
    testitem_t testItem;

    /* UIM_READ_TRANSPARENT :This parameter contains the file information for IMSI Elementary File */
    uim_UIMSessionInformation sessionInfo_IMSI = { 0x00, 0x01, "1" };
    // EF-IMSI file from from 3GPP TS 31.102, section 4.2.2
    uim_fileInfo fileEF_IMSI = {
        0x6F07, // EF-IMSI File ID
        0x04, // Path len, 4 nibbles
        {0x3F00 ,0x7FFF}
        //EF-IMSI path
    }; //IMSI

    uim_readTransparentInfo readtp_IMSI = { 0, 0 };
    uim_cardResult CardResult;
    uim_readResult ReadResult;
    uint32_t IndicationToken = 0xffffffff;
    uint8_t EncryptedData = 0xff;
    pack_uim_ReadTransparent_t req;
    unpack_uim_ReadTransparent_t output;
    uint16_t count;

    memset(&req,0,sizeof(req));
    memset(&output,0,sizeof(output));
    memset(&CardResult,0,sizeof(CardResult));
    memset(&ReadResult,0,sizeof(ReadResult));

    memcpy(&(req.sessionInfo),&sessionInfo_IMSI,sizeof(uim_UIMSessionInformation));
    memcpy(&(req.fileIndex),&fileEF_IMSI,sizeof(uim_fileInfo));
    memcpy(&(req.readTransparent),&readtp_IMSI,sizeof(uim_readTransparentInfo));

    req.pIndicationToken = NULL;
    req.pEncryptData = NULL;
    output.pCardResult = &CardResult;
    output.pEncryptedData = &EncryptedData;
    output.pIndicationToken = &IndicationToken;
    output.pReadResult = &ReadResult;

    testItem.pack = (pack_func_item) &pack_uim_ReadTransparent;
    strcpy(testItem.pack_func_name, "pack_uim_ReadTransparent");
    testItem.pack_ptr = &req;
    testItem.unpack = (unpack_func_item) &unpack_uim_ReadTransparent;
    strcpy(testItem.unpack_func_name, "unpack_uim_ReadTransparent");
    testItem.unpack_ptr = &output;

   if (ExecuteUimTestCase(pQmiService, &testItem) == eQCWWAN_ERR_NONE)
   {
        if (( NULL != output.pCardResult ) && (swi_uint256_get_bit (output.ParamPresenceMask, 16)))
        {
            printf("\n  SW1 received from card :%x\n", output.pCardResult->sw1 );
            printf("  SW2 received from card :%x\n", output.pCardResult->sw2 );
        }
        if (( NULL != output.pReadResult) && (swi_uint256_get_bit (output.ParamPresenceMask, 17)))
        {
            printf("   length: %d\n", output.pReadResult->contentLen);
            printf("   IMSI: ");
            for(count=1; count < output.pReadResult->contentLen; count++)
            { 
                if(count!=1)/*Skip the first nibble */
                    printf("%x",output.pReadResult->content[count] & 0x0f);
                printf("%x", (output.pReadResult->content[count]>>4) & 0x0f);
            }
            printf("\n");
        }
   }
}

void uim_indication_handler(uint16_t msgid, uint8_t *qmiData, uint32_t qmiDataSize)
{
    int rtn = 0;
    switch (msgid)
    {
        case eQMI_UIM_GET_FILE_ATTRIBUTES_IND:
        {
            unpack_uim_SLQSUIMGetFileAttibutes_Ind_t sGetFileAttributesInd;
            memset(&sGetFileAttributesInd, 0, sizeof(unpack_uim_SLQSUIMGetFileAttibutes_Ind_t));


            rtn = unpack_uim_GetFileAttributesInd_ind(qmiData, qmiDataSize, &sGetFileAttributesInd);

            if (rtn != eQCWWAN_ERR_NONE)
            {
                printf (ANSI_COLOR_RED);
                printf("\nunpack_uim_GetFileAttributesInd_ind errorCode: %d\n", rtn);
            }
            else
            {
                DisplayGetFileAttributesInd(&sGetFileAttributesInd);                
            }
        }
        break;
        case eQMI_UIM_SET_PIN_PROTECTION_IND:
        case eQMI_UIM_VERIFY_PIN_IND:
        case eQMI_UIM_CHANGE_PIN_IND:
        case eQMI_UIM_STATUS_CHANGE_IND:
        case eQMI_UIM_REFRESH_IND:
        break;
        case eQMI_UIM_SLOT_STATUS_IND:
        {
            unpack_uim_SetUimSlotStatusChangeCallback_ind_t sSlotStatusChangeCallback_ind;
            rtn = unpack_uim_SetUimSlotStatusChangeCallback_ind(qmiData, qmiDataSize, &sSlotStatusChangeCallback_ind);

            if (rtn != eQCWWAN_ERR_NONE)
            {
                printf (ANSI_COLOR_RED);
                printf("\nunpack_dms_SetEventReport_ind errorCode: %d\n", rtn);
            }
            else
            {
                DisplaySlotStatusChangeInd(&sSlotStatusChangeCallback_ind);
            }
        }
        break;
    }
    printf (ANSI_COLOR_RESET);
}

enum eQCWWANError ExecuteUimTestCase(QmiService* pQmiService, testitem_t *pTestParams)
{
    enum eQCWWANError qcError = eQCWWAN_ERR_NONE;
    int ret = FAILURE;
    pack_qmi_t  req_ctx;
    
    QmiSyncObject syncObject;
    QmiSyncObject_Initialize(&syncObject);

    memset(&req_ctx, 0, sizeof(req_ctx));	

    // Obtain transaction ID.
    req_ctx.xid = QmiService_GetNextTransactionId(pQmiService);
	
    qcError = run_pack_item(pTestParams->pack)(&req_ctx, syncObject.buffer, &syncObject.bufferSize, pTestParams->pack_ptr);
    if(qcError != eQCWWAN_ERR_NONE)
 	{	
        fprintf (stderr, "packing function %s returned error %d: %s\n", 
                    pTestParams->pack_func_name,
                    qcError, helper_get_error_reason(qcError));
        QmiSyncObject_Destroy(&syncObject);
        return qcError;
	}	
	
	QmiSyncObject_Lock(&syncObject);

    ret = QmiService_SendRequest(
		pQmiService, 
		req_ctx.xid, 
		syncObject.buffer, 
		syncObject.bufferSize, 
		QmiSyncObject_ResponseCallback, 
		(void*)&syncObject
		);

	if (ret != SUCCESS)
	{
        fprintf(stderr,"error, failed to run qmi command\n");
		QmiSyncObject_Unlock(&syncObject);
	}
	else
	{
		ret = QmiSyncObject_TimedWait(&syncObject, 10);			
		QmiSyncObject_Unlock(&syncObject);

		if (ret != SUCCESS)
		{
			fprintf (stderr, "Function timed out\n");
			QmiService_CancelTransaction(pQmiService, req_ctx.xid);	
		}
		else
		{
            if (pTestParams->unpack)
            {
                qcError = run_unpack_item (pTestParams->unpack) (syncObject.buffer, syncObject.bufferSize, pTestParams->unpack_ptr);	
                if (qcError != eQCWWAN_ERR_NONE)
                {	
                    fprintf (stderr, "unpack function %s returned error %d: %s\n", 
                        pTestParams->unpack_func_name, qcError, helper_get_error_reason(qcError));
                }
            }
            else 
            {
                #ifdef TEST_DBG
                fprintf (stderr, "no unpack function\n");
                #endif
            }
		}
	}

    QmiSyncObject_Destroy(&syncObject);

    return qcError;
}
