#include <sys/io.h>
#include <stdio.h>
#include <stdlib.h>
#include <curses.h>
#include <semaphore.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>
#include "pwr_acce.h"



/* For User Interface */
int running = 0;

sem_t plotting;
int   baseLine = 0;

WINDOW *subWinLeft  = NULL;
WINDOW *subWinR1 = NULL;

static void *scanReg(void *);
static void *inputCmd(void *);

static void showWinText(WINDOW *win, int lines, int cols, char *str);
static void clearLine(WINDOW *win, int lines, int cols);
static void printLeftText(void);

/* End */

int main(void)
{
  int subLinesLeft = 0;
  int subLinesRight = 0;
  int subCols = 0;

  pthread_t scanningRegThd;
  pthread_t inputingCmdThd;

  initscr();

  /*
   * Start colors
   */
  if( !has_colors() ) {
    fprintf(stderr, "No color support");
    exit(1);
  }
  
  if( start_color() != OK ) {
    fprintf( stderr, "Start color fail");
    exit(1);
  }

  subLinesLeft  = LINES - 4;
  subLinesRight = LINES - 4;
  subCols       = (COLS - 7) / 2;


  subWinLeft = newwin( subLinesLeft, subCols, 2, 2);
  scrollok( subWinLeft, 1);

  subWinR1 = newwin( subLinesRight, subCols, 2, 2+subCols+3);
  scrollok( subWinR1, 1);

  init_pair(3, COLOR_BLACK, COLOR_YELLOW );  
  init_pair(70, COLOR_WHITE,  COLOR_BLACK);

  wattrset( stdscr, COLOR_PAIR(3) );

  /* Plot Frame */
  move(0, 0);
  hline(' ', COLS); // Top herizon
  move(LINES-1, 0);
  hline(' ', COLS); // Bottom herizon

  move(1, 0); // left 
  vline(' ', LINES-2);
  move(1, 2+subCols+1); // middle
  vline(' ', LINES-2);
  move(1, COLS-1); // right
  vline(' ', LINES-2);

  move(2+subLinesRight+1, 2+subCols+1);
  hline(' ', subCols+4); 
  move(2+subLinesRight+3+subLinesRight+1, 2+subCols+1);
  hline(' ', subCols+4); 
  refresh();

  wattrset( stdscr, COLOR_PAIR(70) );
  /* End */

  /* Print out the main items at the left window. */
  printLeftText();

  sem_init(&plotting, 0, 1);

  running = 1;
  pthread_create(&scanningRegThd, NULL, scanReg, NULL );
  pthread_create(&inputingCmdThd, NULL, inputCmd, NULL );

  pthread_join( inputingCmdThd, NULL );
  pthread_join( scanningRegThd, NULL );

  sem_destroy( &plotting );

  delwin(subWinR1);
  delwin(subWinLeft);

  endwin();

  exit(0);
}

void *inputCmd(void *ptr)
{
  char num = 0;
  unsigned long delay = 999;
  int result = -1;
  int i;
  unsigned char setTime[3] = {0x0};

  while( running )
  {

    wscanw(subWinLeft, "%d", &num);
    wrefresh(subWinLeft);

    if( num != 0 ) {

      if( num != 1 && num != 2 && num != 3 && num != 4 && num!=5 ) {
        showWinText(subWinLeft, baseLine+2, 0, "Wrong number!");
        sleep(1);
        werase(subWinLeft);
        printLeftText();

        continue;
      }

      switch( num ) {
        case 1:
            /* ---- switch(num) case 1 ---- */
            while( delay < 0 || delay > 255) {
              showWinText(subWinLeft, baseLine+3, 0, "( 0 < delay < 255)");
              showWinText(subWinLeft, baseLine+2, 0, "Please input the time of delay in seconds: ");
              wscanw(subWinLeft, "%d", &delay);
            }
              
            result = -1;
            result = setSoftOffDelayS(delay);
            if( result == -1 ) {
              wprintw(subWinLeft, "\nWrite Soft Off Delay Error!!!\n");
            }

            werase(subWinLeft);
            printLeftText();

            delay = 999;

            break;
  
        case 2:
              /* ---- switch(num) case 2 ---- */
            while( delay < 0 || delay > 255) {
              showWinText(subWinLeft, baseLine+3, 0, "( 0 < delay < 256)");
              showWinText(subWinLeft, baseLine+2, 0, "Please input the time of delay in seconds: ");
              wscanw(subWinLeft, "%d", &delay);
            }
              
            result = -1;
            result = setHardOffDelayS(delay);
            if( result == -1 ) {
              wprintw(subWinLeft, "\nWrite Hard Off Delay Error!!!\n");
            }

            werase(subWinLeft);
            printLeftText();

            delay = 999;

            break;

        case 3:
            /* ---- switch(num) case 3 ---- */
            showWinText(subWinLeft, baseLine+2, 0, "(4) Ignition Switch\n(5) Remote Switch\n");
          

            while( num !=  4 && num != 5 ) {
              clearLine(subWinLeft, baseLine+2, 0);
              clearLine(subWinLeft, baseLine+3, 0);
              clearLine(subWinLeft, baseLine+4, 0);
              showWinText(subWinLeft, baseLine+2, 0, "(4) Ignition Switch\n(5) Remote Switch\n");
              wscanw(subWinLeft, "%d", &num );

            }

            if( num == 4 ) {

              result = -1;
              result = setPowerOnMode(IGN_MOD);
              if( result == -1 ) 
                wprintw(subWinLeft, "\nWrite Power On Mode Error!!!\n");

            } else {

              result = -1;
              result = setPowerOnMode(RMT_SWH_MOD);
              if( result == -1 ) 
                wprintw(subWinLeft, "\nWrite Power On Mode Error!!!\n");
        
            }

            werase(subWinLeft);
            printLeftText();

            break;

        case 4:
            setPicDefault();

            werase(subWinLeft);
            printLeftText();

            break;

				case 5:
            while( delay < 0 || delay > 255) {
              showWinText(subWinLeft, baseLine+3, 0, "( 0 < delay < 255)");
              showWinText(subWinLeft, baseLine+2, 0, "Please input the time of delay in minutes: ");
              wscanw(subWinLeft, "%d", &delay);
            }
              
            result = -1;
            result = setSoftOffDelayM(delay);
            if( result == -1 ) {
              wprintw(subWinLeft, "\nWrite Soft Off Delay in minutes, Error!!!\n");
            }

            werase(subWinLeft);
            printLeftText();

            delay = 999;

            break;
 

        default:
          break;

      } // End of switch()

    } else {
      running = 0;
    } // End of 'if( num != 0 )'
  }

  pthread_exit(NULL);
}

void *scanReg(void *ptr)
{
  int result = -1;

  while( running )
  {
    int i;
    unsigned long setTime = 0;
    unsigned char ignition    = 0x0;
    unsigned char powerOnMode = 0x0;
    unsigned char voltData[2] = {0x0, 0x0};
    unsigned short volt = 0;
    PicInfo version;
    unsigned char picMode = 0x0;

    sem_wait(&plotting);

    werase( subWinR1 );

    /* Ignition Status */
    result = getIgnStatus( &ignition );
    if( result == -1 ) {
      clearLine(subWinR1, 1, 1);

      wprintw(subWinR1, "Ignition status can't be identified.\n\n");
    } else {

      if( ignition == IGN_ON ) {

        clearLine(subWinR1, 1, 1);
        wprintw(subWinR1, "Ignition is ON (%2x).\n\n", ignition );

      } else {

        clearLine(subWinR1, 1, 1);
        wprintw(subWinR1, "Ignition is OFF (%2x).\n\n", ignition );
      }
    }

    /* Soft Off Delay */
    result = -1;
    result = getSoftOffDelay(&setTime);

    clearLine(subWinR1, 4, 1);

    if( result != -1 )
      wprintw(subWinR1, "Soft Off Dealy: %d\n", setTime);
    else
      wprintw(subWinR1, "Soft Off Dealy: UNKNOWN\n\n");

      setTime = 0;

    /* Hard Off Delay */
    result = -1;
    result = getHardOffDelay(&setTime);

    clearLine(subWinR1, 7, 1);

    if( result != -1 )
      wprintw(subWinR1, "Hard Off Dealy: %d\n", setTime);
    else
      wprintw(subWinR1, "Hard Off Dealy: UNKNOWN\n\n");

      setTime = 0;


    /* Power-On Mode */
    result = -1;
    result = getPowerOnMode( &powerOnMode );

    clearLine(subWinR1, 10, 1);

    if( result != -1 ) {
      if( powerOnMode == IGN_MOD )
        wprintw(subWinR1, "Power ON mode is Ignition Switch\n\n");
      else
        wprintw(subWinR1, "Power ON mode is Remote Switch\n\n");
    } else {
       wprintw(subWinR1, "Power ON mode: UNKNOWN\n\n");
    }

    /* Battery Voltage */
    result = -1;
    result = getBattVolt( voltData );

    clearLine(subWinR1, 13, 1);

    if( result != -1 ) {
      volt = (volt | voltData[1]) << 8;
      volt = volt | voltData[0];
			
			wprintw(subWinR1, "Battery Voltage is %2.2f\n\n", ( (double)volt*6*5 ) / 1024 );
    } else {
			wprintw(subWinR1, "Battery Voltage is unknown.\n\n");
		}

    /* Show PIC Firmware Version */
    result = -1;
    result = getPicFwVer( &version );

    clearLine(subWinR1, 16, 1);

    if( result != -1 ) {
			wprintw(subWinR1, "PIC Firmware Version %c.%c\n\n", version.majorVersion, version.minorVersion);
		} else {
			wprintw(subWinR1, "PIC Firmware Version is unknown.\n\n");
		}

    /* Get PIC Mode */
    result = -1;
    result = getPicMode(&picMode);

    clearLine(subWinR1, 19, 1);

    if( result != -1 ) {
			wprintw(subWinR1, "PIC Mode: %d\n\n", picMode);
		} else {
			wprintw(subWinR1, "PIC Mode is unknown.\n\n");
		}


    wrefresh(subWinR1);

    sem_post(&plotting);

    usleep(5000);
  }

  pthread_exit(NULL);

}

static void showWinText(WINDOW *win, int lines, int cols, char *str)
{
  sem_wait(&plotting); // <----------
  wmove(win, lines, cols);
  wprintw(win, "\n");
  wmove(win, lines, cols);
  wprintw(win, "%s", str);
  wrefresh(win);
  sem_post(&plotting); // ---------->

  return;
}

void clearLine(WINDOW *win, int lines, int cols)
{
  wmove(win, lines, cols);
  wprintw(win, "\n");
  wmove(win, lines, cols);

  return;
}


static void printLeftText(void)
{
  wmove(subWinLeft, 0, 0);
  wprintw(subWinLeft, "(0) Exit\n");
  wprintw(subWinLeft, "(1) Set Soft Off Delay.\n");
  wprintw(subWinLeft, "(2) Set Hard Off Delay.\n");
  wprintw(subWinLeft, "(3) Set Power On Mode.\n");
  wprintw(subWinLeft, "(4) Set PIC Default.\n");
  wprintw(subWinLeft, "(5) Set Soft Off Dealy in minutes.\n");

  baseLine = 10;
  wmove(subWinLeft, baseLine+0, 0);
  wprintw(subWinLeft, "Please input: ");

  wrefresh(subWinLeft);

  return;
}
