// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the ARB6002_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// ARB6002_API functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.
#ifdef ARB6002_EXPORTS
#define ARB6002_API __declspec(dllexport)
#else
#define ARB6002_API __declspec(dllimport)
#endif

//TYPE DEFINE  
typedef char           i8;
typedef unsigned char  u8;
typedef short          i16;
typedef unsigned short u16;
typedef unsigned long  u32;
typedef int            i32;


/* ----------------------------------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------------------------------------- */
/* ------------------------------------------ Power Subsystem API -------------------------------------- */
/* ----------------------------------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------------------------------------- */
#define IGN_ON				 0xa5 // Ignition ON
#define IGN_OFF				 0x5a // Ignition OFF
#define IGN_MOD				 0xa5 // Ignition mode
#define RMT_SWH_MOD			 0x5a // Remote switch mode

typedef struct {
  u8 type[3];
  u8 model[4];
  u8 majorVersion;
  u8 minorVersion;
} PicInfo;

ARB6002_API i32 setSoftOffDelayS(u32 setTime);
ARB6002_API i32 setSoftOffDelayM(u32 setTime); // new
ARB6002_API i32 setHardOffDelayS(u32 setTime);
ARB6002_API i32 setHardOffDelayM(u32 setTime); // new
ARB6002_API i32 setPowerOnMode(u8 powerOnMode);
ARB6002_API i32 setPicDefault(void);

ARB6002_API i32 getIgnStatus(u8 *ignStatus);
ARB6002_API i32 getSoftOffDelay(u32 *timeDelay);
ARB6002_API i32 getHardOffDelay(u32 *timeDelay);
ARB6002_API i32 getPowerOnMode(u8 *powerOnMode);
ARB6002_API i32 getBattVolt(float *volt);
ARB6002_API i32 getPicFwVer(PicInfo *ver);
ARB6002_API i32 getPicMode(u8 *mode);




/* ----------------------------------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------------------------------------- */
/* --------------------------------------------- CAN Bus API ------------------------------------------- */
/* ----------------------------------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------------------------------------- */

typedef struct timeval {
  long tv_sec;
  long tv_usec;
} timeval;

typedef struct {
    /** flags, indicating or controlling special message properties */
    i32             flags;
    i32             cob;	 /**< CAN object number, used in Full CAN  */
    u32 id;		 /**< CAN message ID, 4 bytes  */
    struct timeval  timestamp;	 /**< time stamp for received messages */
    i16  length;	 /**< number of bytes in the CAN message */
    u8 data[8]; /**< data, 0...8 bytes */
} canmsg_t;

ARB6002_API unsigned int sendCanMessages(canmsg_t* buf, u8 count);
ARB6002_API unsigned int getCanMessages(canmsg_t* buf, u8 count);
ARB6002_API unsigned int configCan(i32 baud);


/* ----------------------------------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------------------------------------- */
/* -------------------------------------- GPIO and Watchdog -------------------------------------------- */
/* ----------------------------------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------------------------------------- */

/*
 * APIs
 */
ARB6002_API u8 getWtdTimer(void);
ARB6002_API void     setWtdTimer(u8 value);
ARB6002_API i32      getInChLevel(i32 channel, u8 *val);
ARB6002_API i32      setOutChLevel(i32 channel, u8 val);
ARB6002_API i32      getOutChLevel(i32 channel, u8 *val);


/* GPIO signal names */
#define GPO0    (0x1 << 0)
#define GPO1    (0x1 << 1)
#define GPO2    (0x1 << 2)
#define GPO3    (0x1 << 3)
#define GPOALL  0xf

#define GPI0     (0x1 << 0)
#define GPI1     (0x1 << 1)
#define GPI2     (0x1 << 2)
#define GPI3     (0x1 << 3)
#define GPIALL   0xf