/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology	5th	Rd.
 * Science-based Industrial	Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2006, Ralink Technology, Inc.
 *
 * All rights reserved.	Ralink's source	code is	an unpublished work	and	the
 * use of a	copyright notice does not imply	otherwise. This	source code
 * contains	confidential trade secret material of Ralink Tech. Any attemp
 * or participation	in deciphering,	decoding, reverse engineering or in	any
 * way altering	the	source code	is stricitly prohibited, unless	the	prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

    Module Name:
    rt_config.h

    Abstract:
    Central header file to maintain all include files for all driver routines.

    Revision History:
    Who         When          What
    --------    ----------    ----------------------------------------------
*/

#ifndef	__RT_CONFIG_H__
#define	__RT_CONFIG_H__

#define PROFILE_PATH                "/etc/Wireless/RT73/rt73.dat"
#define NIC_DEVICE_NAME             "RT73AP"
#define RT2573_IMAGE_FILE_NAME      "/etc/Wireless/RT73/rt73.bin"
#define RALINK_PASSPHRASE           "Ralink"
#define DRIVER_VERSION				"0.1"

// Query from UI
#define DRV_MAJORVERSION        0
#define DRV_MINORVERSION        0
#define DRV_SUBVERSION          0
#define DRV_TESTVERSION         1
#define DRV_YEAR                2006
#define DRV_MONTH               7
#define DRV_DAY                 4

/* Operational parameters that are set at compile time. */
#if !defined(__OPTIMIZE__)  ||  !defined(__KERNEL__)
#warning  You must compile this file with the correct options!
#warning  See the last lines of the source file.
#error  You must compile this driver with "-O".
#endif

#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>

#include <linux/init.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/errno.h>
#include <linux/slab.h>
//#include <linux/interrupt.h>
#include <linux/pci.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/ethtool.h>
#include <linux/wireless.h>
#include <linux/proc_fs.h>
#include <linux/delay.h>
#include <linux/if_arp.h>
#include <linux/ctype.h>
#include <linux/sched.h>
#include <linux/smp_lock.h>
#include <linux/kmod.h>

#include <linux/ioport.h>
//usb header files
#include <linux/usb.h>

#if LINUX_VERSION_CODE >= 0x20407
#include <linux/mii.h>
#endif
#include <asm/processor.h>      /* Processor type for cache alignment. */
#include <asm/bitops.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm-i386/atomic.h>



// ** Wireless Extensions **
// 1. wireless events support        : v14 or newer
// 2. requirements of wpa-supplicant : v15 or newer
#if WIRELESS_EXT >= 15
#define WPA_SUPPLICANT_SUPPORT  0/*1*/ /* fonchi todo. */
#else
#define WPA_SUPPLICANT_SUPPORT  0
#endif

//
//	Hradware related header files
//
#include 	"rt_linux.h"

#include	"rt73.h"

//
//	Miniport defined header files
//
#include	"rtmp_type.h"
#include	"rtmp_def.h"
#include    "oid.h"
#include	"mlme.h"
#include    "md5.h"
#include    "wpa.h"
#include	"aironet.h"
#include	"rtmp.h"
#include	"rtmp_ckipmic.h"
#include	"md4.h"
#include	"leap.h"
#include  "ap_wpa.h"
#include  "ap.h"



#define MEM_ALLOC_FLAG      (GFP_DMA | GFP_ATOMIC)

#ifndef KERNEL_VERSION
#define KERNEL_VERSION(a,b,c) ((a)*65536+(b)*256+(c))
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,0)
#define rtusb_submit_urb(purb) usb_submit_urb(purb, GFP_KERNEL)
#else
#define rtusb_submit_urb(purb) usb_submit_urb(purb)
#endif


#ifndef USB_ST_NOERROR
#define  USB_ST_NOERROR     0
#endif

#define READ_PROFILE_FROM_FILE      //read RaConfig profile parameters from rt73sta.dat
#define INIT_FROM_EEPROM

#define ROUND_UP(__x, __y) \
	(((ULONG)((__x)+((__y)-1))) & ((ULONG)~((__y)-1)))\

#endif	// __RT_CONFIG_H__
