/****************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ****************************************************************************

    Module Name:
    mlme.c

    Abstract:
    Major MLME state machiones here

    Revision History:
    Who         When          What
    --------    ----------    ----------------------------------------------
    John Chang  08-04-2003    created for 11g soft-AP
 */

#include "rt_config.h"
#include <stdarg.h>

/*
    ==========================================================================
    Description:
        This routine is executed every second -
        1. Decide the overall channel quality
        2. Check if need to upgrade the TX rate to any client
        3. perform MAC table maintenance, including ageout no-traffic clients,
           and release packet buffer in PSQ is fail to TX in time.
    ==========================================================================
 */
VOID APMlmePeriodicExec(
    PRTMP_ADAPTER pAd)
{
    // check every 12 second. If no U2M in the past 12 second, then AvgRSSI is no longer a
    // valid indication of the distance between this AP and its clients. In this case, we presume a
    // mid AvgRSSI (say -60 dbm), so that no extreme TX power calibration and BBP R17 tuning
    // rules will be applied.


    if (pAd->Mlme.PeriodicRound % 12 == 2)
    {
        if (pAd->ApCfg.NumOfAvgRssiSample == 0)
        {
        	AsicResetBbpTuning(pAd);
            pAd->ApCfg.AvgRssi = pAd->BbpRssiToDbmDelta + RSSI_FOR_MID_SENSIBILITY - 1;
            pAd->ApCfg.AvgRssiX8 = pAd->ApCfg.AvgRssi << 3;
            DBGPRINT_RAW(RT_DEBUG_TRACE,("APMlmePeriodicExec: no traffic, reset Avg RSSI= %d dbm\n",pAd->ApCfg.AvgRssi - pAd->BbpRssiToDbmDelta));
        }
        else
            pAd->ApCfg.NumOfAvgRssiSample = 0;
    }


	// Media status changed, report to NDIS
	if (RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_MEDIA_STATE_CHANGE))
	{

		RTMP_CLEAR_FLAG(pAd, fRTMP_ADAPTER_MEDIA_STATE_CHANGE);
		if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_MEDIA_STATE_CONNECTED))
		{
			DBGPRINT_RAW(RT_DEBUG_WARN,("APMlme indicate connect \n"));
			pAd->IndicateMediaState = NdisMediaStateConnected;
			NdisMIndicateStatus(pAd->AdapterHandle, NDIS_STATUS_MEDIA_CONNECT, (PVOID)NULL, 0);
		}
		else
		{
			pAd->IndicateMediaState = NdisMediaStateDisconnected;
			NdisMIndicateStatus(pAd->AdapterHandle, NDIS_STATUS_MEDIA_DISCONNECT, (PVOID)NULL, 0);
		}
		NdisMIndicateStatusComplete(pAd->AdapterHandle);
	}
    //
    // Reqeust by David 2005/05/12
    // It make sense to disable Adjust Tx Power on AP mode, since we can't take care all of the client's situation
    // ToDo: need to verify compatibility issue with WiFi product.
    //
    // AsicAdjustTxPower(pAd);

		// add the most up-to-date h/w raw counters into software variable, so that
	// the dynamic tuning mechanism below are based on most up-to-date information
	NICUpdateRawCounters(pAd);

	// danamic tune BBP R17 to find a balance between sensibility and noise isolation
	AsicBbpTuning(pAd);


    //radar detect
   //	if ((pAd->CommonCfg.PhyMode == PHY_11A) && (pAd->CommonCfg.bIEEE80211H == 1) && RadarChannelCheck(pAd, pAd->CommonCfg.Channel))
   //		RadarDetectPeriodic(pAd);

    // walk through MAC table, see if switching TX rate is required
    if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_TX_RATE_SWITCH_ENABLED))
        APMlmeDynamicTxRateSwitching(pAd);

    // MAC table maintenance
    MacTableMaintenance(pAd);
    WdsTableMaintenance(pAd);
    APUpdateCapabilityAndErpIe(pAd);
    /* ~~sample, bug fix for TIM update, 2006/10/04 */
//    if( (pAd->ApCfg.TimBitmap !=0) || (pAd->ApCfg.TimBitmap2 !=0) || pAd->ApCfg.bErpIEChange )
#if 0 /* move to MlmeTBTTExec() */
    if( (pAd->ApCfg.bTimUpdate == 1) || (pAd->ApCfg.TimBitmap !=0) || (pAd->ApCfg.TimBitmap2 !=0) || pAd->ApCfg.bErpIEChange )
    {
        pAd->ApCfg.bTimUpdate = 0;
    	pAd->ApCfg.bErpIEChange = FALSE;
    	APUpdateBeaconFrame(pAd);
     }
#endif
    pAd->Mlme.PeriodicRound++;
}

/*
    ==========================================================================
    Description:
        This routine walks through the MAC table, see if TX rate change is
        required for each associated client.
    Output:
        pEntry->CurrTxRate -
    NOTE:
        call this routine every second
    ==========================================================================
 */
VOID APMlmeDynamicTxRateSwitching(
    IN PRTMP_ADAPTER pAd)
{
    int i;
    UCHAR UpRate, DownRate, CurrRate;
    UCHAR PID;

    //
    // walk through MAC table, see if need to change AP's TX rate toward each entry
    //
    for (i=0; i<MAX_LEN_OF_MAC_TABLE; i++)
    {
        USHORT TxTotalCnt, TxErrorRatio;
        BOOLEAN fUpgradeQuality = FALSE;
        MAC_TABLE_ENTRY *pEntry;

        pEntry = &pAd->MacTab.Content[i];

        // only associated STA counts
        if ((pEntry->Valid == FALSE) || (pEntry->Sst != SST_ASSOC))
            continue;

        pEntry->CurrTxRateStableTime ++;
        TxTotalCnt = pEntry->OneSecTxOkCount + pEntry->OneSecTxRetryOkCount + pEntry->OneSecTxFailCount;

        // skip those STA that has no traffic in the past period
        if (TxTotalCnt == 0)
        {
            pEntry->TxRateUpPenalty = 0;
            continue;
        }

        // decide the next upgrade rate and downgrade rate, if any
        CurrRate = pEntry->CurrTxRate;
        if (pEntry->MaxSupportedRate < RATE_FIRST_OFDM_RATE)
        {
            UpRate = Phy11BNextRateUpward[CurrRate];
            DownRate = Phy11BNextRateDownward[CurrRate];
        }
        else
        {
            UpRate = Phy11BGNextRateUpward[CurrRate];
            DownRate = Phy11BGNextRateDownward[CurrRate];
        }

        //
        // PART 1. Decide TX Quality
        //   decide TX quality based on Tx PER when enough samples are available
        //

        if (TxTotalCnt > 15)
        {
            TxErrorRatio = ((pEntry->OneSecTxRetryOkCount + pEntry->OneSecTxFailCount) *100) / TxTotalCnt;

            // downgrade TX quality if PER >= Rate-Down threshold
            if (TxErrorRatio >= RateDownPER[CurrRate])
            {
                pEntry->TxQuality[CurrRate] = DRS_TX_QUALITY_WORST_BOUND;
            }
            // upgrade TX quality if PER <= Rate-Up threshold
            else if (TxErrorRatio <= RateUpPER[CurrRate])
            {
                fUpgradeQuality = TRUE;
                if (pEntry->TxQuality[CurrRate])
                    pEntry->TxQuality[CurrRate] --;  // quality very good in CurrRate

                if (pEntry->TxRateUpPenalty)
                    pEntry->TxRateUpPenalty --;
                else if (pEntry->TxQuality[UpRate])
                    pEntry->TxQuality[UpRate] --;    // may improve next UP rate's quality
            }

        }

        // if not enough TX samples, decide by heuristic rules
        else
        {
            TxErrorRatio = 0;

            // Downgrade TX quality upon any TX failure in the past second
            if (pEntry->OneSecTxFailCount)
            {
                if ((pEntry->OneSecTxFailCount <= 1) &&
                    (pEntry->OneSecTxOkCount + pEntry->OneSecTxRetryOkCount))
                {
                    pEntry->TxQuality[CurrRate] += 2;  // degrade quality
                    if (pEntry->TxQuality[CurrRate] > DRS_TX_QUALITY_WORST_BOUND)
                        pEntry->TxQuality[CurrRate] = DRS_TX_QUALITY_WORST_BOUND;
                }
                else // more than 2 failure, or no TX ok cases
                {
                    pEntry->TxQuality[CurrRate] = DRS_TX_QUALITY_WORST_BOUND;
                }
            }
            // upgrade TX quality if -
            // 1. no TX failure but do have TX ok case, and
            // 2. there's more one-time-ok cases than retry-ok cases in the past second
            else if (pEntry->OneSecTxOkCount > pEntry->OneSecTxRetryOkCount)
            {
                fUpgradeQuality = TRUE;
                if (pEntry->TxQuality[CurrRate])
                    pEntry->TxQuality[CurrRate] --;  // quality very good in CurrRate

                if (pEntry->TxRateUpPenalty)
                    pEntry->TxRateUpPenalty --;
                else if (pEntry->TxQuality[UpRate])
                    pEntry->TxQuality[UpRate] --;    // may improve next UP rate's quality

            }
        }

        pEntry->PER[CurrRate] = (UCHAR)TxErrorRatio;
        if (pEntry->fNoisyEnvironment)
        {
            DBGPRINT(RT_DEBUG_TRACE,("DRS(Noisy) - [AID# %d] Qty[%d]=%d PER=%d%% %d-sec, Qty[%d]=%d Pty=%d, TX/RX Aggr=<%d,%d>\n",
                pEntry->Aid, RateIdToMbps[CurrRate], pEntry->TxQuality[CurrRate],
                TxErrorRatio, pEntry->CurrTxRateStableTime,
                RateIdToMbps[UpRate], pEntry->TxQuality[UpRate],
                pEntry->TxRateUpPenalty,
                pAd->RalinkCounters.OneSecTxAggregationCount,
                pAd->RalinkCounters.OneSecRxAggregationCount));
        }
        else
        {
            DBGPRINT(RT_DEBUG_TRACE,("DRS: [AID# %d] Qty[%d]=%d PER=%d%% %d-sec, Qty[%d]=%d Pty=%d, TX/RX Aggr=<%d,%d>\n",
                pEntry->Aid, RateIdToMbps[CurrRate], pEntry->TxQuality[CurrRate],
                TxErrorRatio, pEntry->CurrTxRateStableTime,
                RateIdToMbps[UpRate], pEntry->TxQuality[UpRate],
                pEntry->TxRateUpPenalty,
                pAd->RalinkCounters.OneSecTxAggregationCount,
                pAd->RalinkCounters.OneSecRxAggregationCount));
        }

        //
        // PART 2. Perform TX rate switching
        //   perform rate switching
        //

        do
        {
#if 1
            // special case 1: enter NOISY environment
            if ((UpRate != CurrRate)                     &&
                (pEntry->LastSecTxRateChangeAction == 2) &&
                ((pEntry->PER[CurrRate] > 20) || pEntry->fNoisyEnvironment) &&
                (pEntry->PER[CurrRate] < 75)             &&
                ((pEntry->PER[CurrRate]+5) > pEntry->PER[UpRate]))
            {
                // we believe this is a noisy environment. better stay at UpRate
                pEntry->fNoisyEnvironment = TRUE;

                // 2004-3-14 when claiming noisy environment, we're not only switch back
                //   to UpRate, but can be more aggressive to use one more rate up
                UpRate++;
                if (UpRate>RATE_54) UpRate=RATE_54;
                if ((UpRate==RATE_6) || (UpRate==RATE_9)) UpRate=RATE_12;
                pEntry->CurrTxRate = UpRate;
                break;
            }

            // special case 2: leave NOISY environment
            if ((pEntry->fNoisyEnvironment == TRUE) &&
                (TxTotalCnt > 15)                   &&
                (pEntry->PER[CurrRate] <= 12))
            {
                UCHAR JumpUpRate;

                pEntry->fNoisyEnvironment = FALSE;
                for (JumpUpRate = RATE_54; JumpUpRate > RATE_1; JumpUpRate--)
                {
                    if (pAd->ApCfg.AvgRssi > (RssiSafeLevelForTxRate[JumpUpRate] + pAd->BbpRssiToDbmDelta))
                        break;
                }

                if (JumpUpRate > pEntry->MaxSupportedRate)
                    JumpUpRate = pEntry->MaxSupportedRate;

                if (JumpUpRate > CurrRate)
                {
                    pEntry->CurrTxRate = JumpUpRate;
                    break;
                }
            }
#endif
            // we're going to ugrade CurrRate to UpRate at next few seconds,
            // but before that, we'd better try a NULL frame @ UpRate and
            // see if UpRate is stable or not. If this NULL frame fails, it will
            // downgrade TxQuality[CurrRate], so that STA won't switch to
            // to UpRate in the next second
            if ((fUpgradeQuality == TRUE)          &&
                (UpRate != CurrRate)               &&
                (pEntry->TxQuality[CurrRate] <= 1) &&
                (pEntry->TxQuality[UpRate] <= 1))
            {
                DBGPRINT(RT_DEBUG_TRACE,("2 test frames at UpRate = %d Mbps\n",RateIdToMbps[UpRate]));
                // tag PID for later on per-client/WDS TX statistics caculation
                PID = PTYPE_NULL_AT_HIGH_RATE + i;
                // ApEnqueueNullFrame(pAd, pEntry->Addr, UpRate, PID);
                ApEnqueueNullFrame(pAd, pEntry->Addr, UpRate, PID);
            }

            // perform DRS - consider TxRate Down frist, then rate up
            if ((pEntry->TxQuality[CurrRate] >= DRS_TX_QUALITY_WORST_BOUND) && (CurrRate != DownRate))
            {
                pEntry->CurrTxRate = DownRate;
            }
            else if ((pEntry->TxQuality[CurrRate] <=0) && (pEntry->TxQuality[UpRate] <=0) && (CurrRate != UpRate))
            {
                pEntry->CurrTxRate = UpRate;
            }
        }while (FALSE);

        // PART 3. Post-processing if TX rate switching did happen
        //     if rate-up happen, clear all bad history of all TX rates
        //     if rate-down happen, only clear DownRate's bad history
        if (pEntry->CurrTxRate > CurrRate)
        {
            DBGPRINT(RT_DEBUG_TRACE,("DRS: [AID#%d] ++TX rate = %d Mbps\n", pEntry->Aid, RateIdToMbps[UpRate]));
            pEntry->CurrTxRateStableTime = 0;
            pEntry->TxRateUpPenalty = 0;
            pEntry->LastSecTxRateChangeAction = 0;
            NdisZeroMemory(pEntry->TxQuality, MAX_LEN_OF_SUPPORTED_RATES);
            NdisZeroMemory(pEntry->PER, MAX_LEN_OF_SUPPORTED_RATES);
			//
			// For TxRate fast train up, issued by David 2005/05/12
			//
			if (!pAd->ApCfg.ApQuickResponeForRateUpTimerRunning)
			{
				if (pEntry->CurrTxRate <= RATE_12)
					NdisMSetTimer(&pAd->ApCfg.ApQuickResponeForRateUpTimer, 200);
				else
					NdisMSetTimer(&pAd->ApCfg.ApQuickResponeForRateUpTimer, 100);

				pAd->ApCfg.ApQuickResponeForRateUpTimerRunning = TRUE;
			}
        }
        else if (pEntry->CurrTxRate < CurrRate)
        {
            DBGPRINT(RT_DEBUG_TRACE,("DRS: [AID#%d] --TX rate = %d Mbps\n", pEntry->Aid, RateIdToMbps[DownRate]));
#if 0
//Remove this code for TxRate fast train up. issued by David 2005/05/12
            // shorter stable time require more penalty in next rate UP criteria
            //if (pEntry->CurrTxRateStableTime < 4)      // less then 4 sec
            //    pEntry->TxRateUpPenalty = DRS_PENALTY; // add 8 sec penalty
            //else if (pEntry->CurrTxRateStableTime < 8) // less then 8 sec
            //    pEntry->TxRateUpPenalty = 2;           // add 2 sec penalty
            //else
#endif
                pEntry->TxRateUpPenalty = 0;           // no penalty

            pEntry->CurrTxRateStableTime = 0;
            pEntry->LastSecTxRateChangeAction = 2; // rate down
            pEntry->TxQuality[pEntry->CurrTxRate] = 0;
            pEntry->PER[pEntry->CurrTxRate] = 0;
        }
        else
            pEntry->LastSecTxRateChangeAction = 0; // rate no change

        // reset all OneSecxxx counters
        pEntry->OneSecTxFailCount = 0;
        pEntry->OneSecTxOkCount = 0;
        pEntry->OneSecTxRetryOkCount = 0;
    }

#ifdef  WDS
    for (i=0; i<(int)pAd->WdsTab.Size; i++)
    {
        USHORT TxTotalCnt, TxErrorRatio;
        BOOLEAN fUpgradeQuality = FALSE;
        WDS_TABLE_ENTRY *pEntry = &pAd->WdsTab.MacTab[i];

        pEntry->CurrTxRateStableTime ++;
        TxTotalCnt = pEntry->OneSecTxOkCount + pEntry->OneSecTxRetryOkCount + pEntry->OneSecTxFailCount;

        // skip those STA that has no traffic in the past period
        if (TxTotalCnt == 0)
        {
            pEntry->TxRateUpPenalty = 0;
            continue;
        }

        // decide the next upgrade rate and downgrade rate, if any
        CurrRate = pEntry->CurrTxRate;
        if (pEntry->MaxSupportedRate < RATE_FIRST_OFDM_RATE)
        {
            UpRate = Phy11BNextRateUpward[CurrRate];
            DownRate = Phy11BNextRateDownward[CurrRate];
        }
        else
        {
            UpRate = Phy11BGNextRateUpward[CurrRate];
            DownRate = Phy11BGNextRateDownward[CurrRate];
        }

        // calculate Tx with retry ratio when enough samples are available
        if (TxTotalCnt > 15)
        {
            TxErrorRatio = ((pEntry->OneSecTxRetryOkCount + pEntry->OneSecTxFailCount) *100) / TxTotalCnt;

            // downgrade TX quality if retry+error ratio reached
            if (TxErrorRatio >= RateDownPER[CurrRate])
            {
                pEntry->TxQuality[CurrRate] = DRS_TX_QUALITY_WORST_BOUND;
            }
            // upgrade TX quality if retry+error ratio reached
            else if (TxErrorRatio <= RateUpPER[CurrRate])
            {
                fUpgradeQuality = TRUE;
                if (pEntry->TxQuality[CurrRate])
                    pEntry->TxQuality[CurrRate] --;  // quality very good in CurrRate

                if (pEntry->TxRateUpPenalty)
                    pEntry->TxRateUpPenalty --;
                else if (pEntry->TxQuality[UpRate])
                    pEntry->TxQuality[UpRate] --;    // may improve next UP rate's quality
            }
        }
        else
        {
            TxErrorRatio = 0;  // too few samples

            // Downgrade TX quality upon any TX failure in the past second
            if (pEntry->OneSecTxFailCount)
            {
                if ((pEntry->OneSecTxFailCount <= 1) && (pEntry->OneSecTxOkCount + pEntry->OneSecTxRetryOkCount))
                {
                    pEntry->TxQuality[CurrRate] += 2;  // degrade quality
                    if (pEntry->TxQuality[CurrRate] > DRS_TX_QUALITY_WORST_BOUND)
                        pEntry->TxQuality[CurrRate] = DRS_TX_QUALITY_WORST_BOUND;
                }
                else // more than 2 failure, or no TX ok cases
                {
                    pEntry->TxQuality[CurrRate] = DRS_TX_QUALITY_WORST_BOUND;
                }
            }
            // upgrade TX quality if -
            // 1. no TX failure but do have TX ok case, and
            // 2. there's more one-time-ok cases than retry-ok cases in the past second
            else if (pEntry->OneSecTxOkCount > pEntry->OneSecTxRetryOkCount)
            {
                fUpgradeQuality = TRUE;
                if (pEntry->TxQuality[CurrRate])
                    pEntry->TxQuality[CurrRate] --;  // quality very good in CurrRate

                if (pEntry->TxRateUpPenalty)
                    pEntry->TxRateUpPenalty --;
                else if (pEntry->TxQuality[UpRate])
                    pEntry->TxQuality[UpRate] --;    // may improve next UP rate's quality

            }
        }

        DBGPRINT(RT_DEBUG_TRACE,("WDS: Qty[%d]=%d PER=%d%% %d-sec, Qty[%d]=%d Pty=%d\n",
            RateIdToMbps[CurrRate], pEntry->TxQuality[CurrRate],
            TxErrorRatio, pEntry->CurrTxRateStableTime,
            RateIdToMbps[UpRate], pEntry->TxQuality[UpRate],
            pEntry->TxRateUpPenalty));

        // we're going to ugrade CurrRate to UpRate at next few seconds,
        // but before that, we'd better try a NULL frame @ UpRate and
        // see if UpRate is stable or not. If this NULL frame fails, it will
        // downgrade TxQuality[CurrRate], so that STA won't switch to
        // to UpRate in the next second
        if ((fUpgradeQuality == TRUE)          &&
            (UpRate != CurrRate)               &&
            (pEntry->TxQuality[CurrRate] <= 1) &&
            (pEntry->TxQuality[UpRate] <= 1))
        {
            DBGPRINT(RT_DEBUG_TRACE,("2 test frames at UpRate = %d Mbps\n",RateIdToMbps[UpRate]));
            // tag PID for later on per-client/WDS TX statistics caculation
            PID = PTYPE_NULL_AT_HIGH_RATE + WDS_PAIRWISE_KEY_OFFSET + i;
            ApEnqueueNullFrame(pAd, pEntry->WdsAddr, UpRate, PID);
            ApEnqueueNullFrame(pAd, pEntry->WdsAddr, UpRate, PID);
        }

        // perform DRS - consider TxRate Down frist, then rate up
        //     rate down, if current TX rate's quality is not good
        //     rate up, if UPRate's quality is very good
        if ((pEntry->TxQuality[CurrRate] >= DRS_TX_QUALITY_WORST_BOUND) && (CurrRate != DownRate))
        {
            pEntry->CurrTxRate = DownRate;
        }
        else if ((pEntry->TxQuality[CurrRate] <=0) && (pEntry->TxQuality[UpRate] <=0) && (CurrRate != UpRate))
        {
            pEntry->CurrTxRate = UpRate;
        }

        // if rate-up happen, clear all bad history of all TX rates
        if (pEntry->CurrTxRate > CurrRate)
        {
            DBGPRINT(RT_DEBUG_TRACE,("WDS: ++TX rate = %d Mbps\n", RateIdToMbps[UpRate]));
            pEntry->CurrTxRateStableTime = 0;
            pEntry->TxRateUpPenalty = 0;
            NdisZeroMemory(pEntry->TxQuality, MAX_LEN_OF_SUPPORTED_RATES);
        }
        // if rate-down happen, only clear DownRate's bad history
        else if (pEntry->CurrTxRate < CurrRate)
        {
            DBGPRINT(RT_DEBUG_TRACE,("WDS: --TX rate = %d Mbps\n", RateIdToMbps[DownRate]));

            // shorter stable time require more penalty in next rate UP criteria
            if (pEntry->CurrTxRateStableTime < 4)      // less then 4 sec
                pEntry->TxRateUpPenalty = DRS_PENALTY; // add 8 sec penalty
            else if (pEntry->CurrTxRateStableTime < 8) // less then 8 sec
                pEntry->TxRateUpPenalty = 2;           // add 2 sec penalty
            else
                pEntry->TxRateUpPenalty = 0;           // no penalty

            pEntry->CurrTxRateStableTime = 0;
            pEntry->TxQuality[pEntry->CurrTxRate] = 0;
        }

        // reset all OneSecxxx counters
        pEntry->OneSecTxFailCount = 0;
        pEntry->OneSecTxOkCount = 0;
        pEntry->OneSecTxRetryOkCount = 0;
    }
#endif
}

/*! \brief   To substitute the message type if the message is coming from external
 *  \param  *Fr            The frame received
 *  \param  *Machine       The state machine
 *  \param  *MsgType       the message type for the state machine
 *  \return TRUE if the substitution is successful, FALSE otherwise
 *  \pre
 *  \post
 */
BOOLEAN APMsgTypeSubst(
    IN PRTMP_ADAPTER pAd,
    IN PFRAME_802_11 pFrame,
    OUT INT *Machine,
    OUT INT *MsgType)
{
    USHORT Seq;
    UCHAR  EAPType;
//TODO:
// only PROBE_REQ can be broadcast, all others must be unicast-to-me && is_mybssid; otherwise,
// ignore this frame

    // wpa EAPOL PACKET
    if (pFrame->Hdr.FC.Type == BTYPE_DATA)
    {
        *Machine = AP_WPA_STATE_MACHINE;
        EAPType = *((UCHAR*)pFrame + LENGTH_802_11 + LENGTH_802_1_H + 1);
        return WPAMsgTypeSubst(EAPType, MsgType);
    }

    if (pFrame->Hdr.FC.Type != BTYPE_MGMT)
        return FALSE;

    switch (pFrame->Hdr.FC.SubType)
    {
        case SUBTYPE_ASSOC_REQ:
            *Machine = AP_ASSOC_STATE_MACHINE;
            *MsgType = APMT2_PEER_ASSOC_REQ;
            break;
//      case SUBTYPE_ASSOC_RSP:
//          *Machine = AP_ASSOC_STATE_MACHINE;
//          *MsgType = APMT2_PEER_ASSOC_RSP;
//          break;
        case SUBTYPE_REASSOC_REQ:
            *Machine = AP_ASSOC_STATE_MACHINE;
            *MsgType = APMT2_PEER_REASSOC_REQ;
            break;
//      case SUBTYPE_REASSOC_RSP:
//          *Machine = AP_ASSOC_STATE_MACHINE;
//          *MsgType = APMT2_PEER_REASSOC_RSP;
//          break;
        case SUBTYPE_PROBE_REQ:
            *Machine = AP_SYNC_STATE_MACHINE;
            *MsgType = APMT2_PEER_PROBE_REQ;
            break;
//      case SUBTYPE_PROBE_RSP:
//          *Machine = AP_SYNC_STATE_MACHINE;
//          *MsgType = APMT2_PEER_PROBE_RSP;
//          break;
        case SUBTYPE_BEACON:
            *Machine = AP_SYNC_STATE_MACHINE;
            *MsgType = APMT2_PEER_BEACON;
            break;
//      case SUBTYPE_ATIM:
//          *Machine = AP_SYNC_STATE_MACHINE;
//          *MsgType = APMT2_PEER_ATIM;
//          break;
        case SUBTYPE_DISASSOC:
            *Machine = AP_ASSOC_STATE_MACHINE;
            *MsgType = APMT2_PEER_DISASSOC_REQ;
            break;
        case SUBTYPE_AUTH:
            // get the sequence number from payload 24 Mac Header + 2 bytes algorithm
            NdisMoveMemory(&Seq, &pFrame->Octet[2], sizeof(USHORT));
            DBGPRINT(RT_DEBUG_INFO,("AUTH seq=%d Octet=%02x %02x %02x %02x %02x %02x %02x %02x\n", Seq,
                pFrame->Octet[0], pFrame->Octet[1], pFrame->Octet[2], pFrame->Octet[3],
                pFrame->Octet[4], pFrame->Octet[5], pFrame->Octet[6], pFrame->Octet[7]));
            if (Seq == 1 || Seq == 3)
            {
                *Machine = AP_AUTH_RSP_STATE_MACHINE;
                *MsgType = APMT2_PEER_AUTH_ODD;
            }
//          else if (Seq == 2 || Seq == 4)
//          {
//              *Machine = AP_AUTH_STATE_MACHINE;
//              *MsgType = APMT2_PEER_AUTH_EVEN;
//          }
            else
            {
                DBGPRINT(RT_DEBUG_TRACE,("wrong AUTH seq=%d Octet=%02x %02x %02x %02x %02x %02x %02x %02x\n", Seq,
                    pFrame->Octet[0], pFrame->Octet[1], pFrame->Octet[2], pFrame->Octet[3],
                    pFrame->Octet[4], pFrame->Octet[5], pFrame->Octet[6], pFrame->Octet[7]));
                return FALSE;
            }
            break;
        case SUBTYPE_DEAUTH:
            *Machine = AP_AUTH_RSP_STATE_MACHINE;
            *MsgType = APMT2_PEER_DEAUTH;
            break;
        default:
            return FALSE;
            break;
    }

    return TRUE;
}

/*
    ========================================================================
    Routine Description:
        AP side, Auto TxRate faster train up timer call back function.

    Arguments:
    	SystemSpecific1			- Not used.
    	FunctionContext			- Pointer to our Adapter context.
    	SystemSpecific2			- Not used.
    	SystemSpecific3			- Not used.

    Return Value:
        None

    ========================================================================
*/
VOID APQuickResponeForRateUpExec(
    IN PVOID SystemSpecific1,
    IN PVOID FunctionContext,
    IN PVOID SystemSpecific2,
    IN PVOID SystemSpecific3)
{
    PRTMP_ADAPTER   pAd = (PRTMP_ADAPTER)FunctionContext;
	INT		i;
    UCHAR	UpRate, DownRate, CurrRate;
//    UCHAR	PID;

    //
    // walk through MAC table, see if need to change AP's TX rate toward each entry
    //
    for (i=0; i<MAX_LEN_OF_MAC_TABLE; i++)
    {
        USHORT TxTotalCnt, TxErrorRatio = 0;
        MAC_TABLE_ENTRY *pEntry = &pAd->MacTab.Content[i];

        // only associated STA counts
        if ((pEntry->Valid == FALSE) || (pEntry->Sst != SST_ASSOC))
            continue;

        TxTotalCnt = pEntry->OneSecTxOkCount + pEntry->OneSecTxRetryOkCount + pEntry->OneSecTxFailCount;

        // skip those STA that has no traffic in the past period
        if (TxTotalCnt == 0)
        {
            pEntry->TxRateUpPenalty = 0;
            continue;
        }

        // decide the next upgrade rate and downgrade rate, if any
        CurrRate = pEntry->CurrTxRate;
        if (pAd->CommonCfg.Channel > 14)  // must be in 802.11A band
        {
            if (Phy11ANextRateUpward[CurrRate] <= pEntry->MaxSupportedRate)
				UpRate = Phy11ANextRateUpward[CurrRate];
        	else
        		UpRate = CurrRate;
            DownRate = Phy11ANextRateDownward[CurrRate];
        }
        else
        {
            if (pEntry->MaxSupportedRate < RATE_FIRST_OFDM_RATE)
	        {
	        	if (Phy11BNextRateUpward[CurrRate] <= pEntry->MaxSupportedRate)
					UpRate = Phy11BNextRateUpward[CurrRate];
	        	else
	        		UpRate = CurrRate;
	            DownRate = Phy11BNextRateDownward[CurrRate];
	        }
	        else
	        {
	        	if (Phy11BGNextRateUpward[CurrRate] <= pEntry->MaxSupportedRate)
					UpRate = Phy11BGNextRateUpward[CurrRate];
	        	else
	        		UpRate = CurrRate;
	            DownRate = Phy11BGNextRateDownward[CurrRate];
	        }
        }

        //
        // PART 1. Decide TX Quality
        //   decide TX quality based on Tx PER when enough samples are available
        //
        if (TxTotalCnt > 15)
        {
            TxErrorRatio = ((pEntry->OneSecTxRetryOkCount + pEntry->OneSecTxFailCount) *100) / TxTotalCnt;

            // downgrade TX quality if PER >= Rate-Down threshold
            if (TxErrorRatio >= RateDownPER[CurrRate])
            {
                pEntry->TxQuality[CurrRate] = DRS_TX_QUALITY_WORST_BOUND;
            }

        }

        pEntry->PER[CurrRate] = (UCHAR)TxErrorRatio;

        //
        // PART 2. Perform TX rate switching
        //   perform rate switching
        //
		if ((pEntry->TxQuality[CurrRate] >= DRS_TX_QUALITY_WORST_BOUND) && (CurrRate != DownRate))
        {
            pEntry->CurrTxRate = DownRate;
        }
        // PART 3. Post-processing if TX rate switching did happen
        //     if rate-up happen, clear all bad history of all TX rates
        //     if rate-down happen, only clear DownRate's bad history

        if (pEntry->CurrTxRate < CurrRate)
        {
            DBGPRINT(RT_DEBUG_TRACE,("DRS: [AID#%d] --TX rate = %d Mbps\n", pEntry->Aid, RateIdToMbps[DownRate]));

            // shorter stable time require more penalty in next rate UP criteria
            //if (pEntry->CurrTxRateStableTime < 4)      // less then 4 sec
            //    pEntry->TxRateUpPenalty = DRS_PENALTY; // add 8 sec penalty
            //else if (pEntry->CurrTxRateStableTime < 8) // less then 8 sec
            //    pEntry->TxRateUpPenalty = 2;           // add 2 sec penalty
            //else
                pEntry->TxRateUpPenalty = 0;           // no penalty

            pEntry->CurrTxRateStableTime = 0;
            pEntry->LastSecTxRateChangeAction = 2; // rate down
            pEntry->TxQuality[pEntry->CurrTxRate] = 0;
            pEntry->PER[pEntry->CurrTxRate] = 0;
        }
        else
            pEntry->LastSecTxRateChangeAction = 0; // rate no change

        // reset all OneSecxxx counters
        pEntry->OneSecTxFailCount = 0;
        pEntry->OneSecTxOkCount = 0;
        pEntry->OneSecTxRetryOkCount = 0;
	}
	pAd->ApCfg.ApQuickResponeForRateUpTimerRunning = FALSE;
}


