/****************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ****************************************************************************

    Module Name:
    connect.c

    Abstract:
    Routines to deal Link UP/DOWN and build/update BEACON frame contents

    Revision History:
    Who         When          What
    --------    ----------    ----------------------------------------------
    John Chang  08-04-2003    created for 11g soft-AP
 */

#include "rt_config.h"

/*
	==========================================================================
	Description:
		Pre-build a BEACON frame in the shared memory
	==========================================================================
*/
VOID APMakeBssBeacon(
	IN PRTMP_ADAPTER pAd)
{
//	UCHAR         DsLen = 1, TimLen = 4,
//				  BitmapControl = 0, VirtualBitmap = 0, EmptySsidLen = 0, SsidLen;
	UCHAR         DsLen = 1, SsidLen;
	UCHAR         RSNIe=IE_WPA, RSNIe2=IE_WPA2;
	HEADER_802_11 BcnHdr;
	LARGE_INTEGER FakeTimestamp;
	ULONG         FrameLen;
	PTXD_STRUC    pTxD = &pAd->BeaconTxD;
	PUCHAR        pBeaconFrame = pAd->BeaconBuf;

	RTUSBWriteMACRegister(pAd, HW_BEACON_BASE0, 0); // invalidate BEACON0 owner/valid bit to prevent garbage
	RTUSBWriteMACRegister(pAd, HW_BEACON_BASE1, 0); // invalidate BEACON1 owner/valid bit to prevent garbage
	RTUSBWriteMACRegister(pAd, HW_BEACON_BASE2, 0); // invalidate BEACON2 owner/valid bit to prevent garbage
	RTUSBWriteMACRegister(pAd, HW_BEACON_BASE3, 0); // invalidate BEACON3 owner/valid bit to prevent garbage

	if (pAd->ApCfg.bHideSsid)
		SsidLen = 0;
	else
		SsidLen = pAd->CommonCfg.SsidLen;

	MgtMacHeaderInit(pAd, &BcnHdr, SUBTYPE_BEACON, 0, BROADCAST_ADDR, pAd->CommonCfg.Bssid);

	if ((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA) ||
		(pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPAPSK))
		RSNIe = IE_WPA;
	else if ((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2) ||
		(pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2PSK))
		RSNIe = IE_WPA2;

	MakeOutgoingFrame(pBeaconFrame,                  &FrameLen,
					sizeof(HEADER_802_11),           &BcnHdr,
					TIMESTAMP_LEN,                   &FakeTimestamp,
					2,                               &pAd->CommonCfg.BeaconPeriod,
					2,                               &pAd->ApCfg.CapabilityInfo,
					1,                               &SsidIe,
					1,                               &SsidLen,
					SsidLen,                         pAd->CommonCfg.Ssid,
					1,                               &SupRateIe,
					1,                               &pAd->CommonCfg.SupRateLen,
					pAd->CommonCfg.SupRateLen,       pAd->CommonCfg.SupRate,
					1,                               &DsIe,
					1,                               &DsLen,
					1,                               &pAd->CommonCfg.Channel,
					END_OF_ARGS);

	if (pAd->CommonCfg.ExtRateLen)
	{
		ULONG TmpLen;
		MakeOutgoingFrame(pBeaconFrame+FrameLen,         &TmpLen,
						1,                               &ExtRateIe,
						1,                               &pAd->CommonCfg.ExtRateLen,
						pAd->CommonCfg.ExtRateLen,           pAd->CommonCfg.ExtRate,
						END_OF_ARGS);
		FrameLen += TmpLen;
	}

	// Append RSN_IE when  WPA OR WPAPSK,
	if ((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA1WPA2) ||
		(pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA1PSKWPA2PSK))
	{
		ULONG TmpLen;
		MakeOutgoingFrame(pBeaconFrame+FrameLen,        &TmpLen,
						  1,                            &RSNIe,
						  1,                            &pAd->ApCfg.RSNIE_Len[0],
						  pAd->ApCfg.RSNIE_Len[0],      pAd->ApCfg.RSN_IE[0],
						  1,                            &RSNIe2,
						  1,                            &pAd->ApCfg.RSNIE_Len[1],
						  pAd->ApCfg.RSNIE_Len[1],      pAd->ApCfg.RSN_IE[1],
						  END_OF_ARGS);
		FrameLen += TmpLen;
	}
	else if (pAd->CommonCfg.AuthMode >= Ndis802_11AuthModeWPA)
	{
		ULONG TmpLen;
		MakeOutgoingFrame(pBeaconFrame+FrameLen,        &TmpLen,
						  1,                            &RSNIe,
						  1,                            &pAd->ApCfg.RSNIE_Len[0],
						  pAd->ApCfg.RSNIE_Len[0],      pAd->ApCfg.RSN_IE[0],
						  END_OF_ARGS);
		FrameLen += TmpLen;
	}
#if 0 //don't support wmm at soft ap
	// add WMM IE here
	if (pAd->CommonCfg.bWmmCapable)
	{
		ULONG TmpLen;
		UCHAR i;
		UCHAR WmeParmIe[26] = {IE_VENDOR_SPECIFIC, 24, 0x00, 0x50, 0xf2, 0x02, 0x01, 0x01, 0, 0};
		WmeParmIe[8] = pAd->ApCfg.BssEdcaParm.EdcaUpdateCount & 0x0f;
		for (i=QID_AC_BE; i<=QID_AC_VO; i++)
		{
			WmeParmIe[10+ (i*4)] = (i << 5)                                         +     // b5-6 is ACI
								   ((UCHAR)pAd->ApCfg.BssEdcaParm.bACM[i] << 4)     +     // b4 is ACM
								   (pAd->ApCfg.BssEdcaParm.Aifsn[i] & 0x0f);              // b0-3 is AIFSN
			WmeParmIe[11+ (i*4)] = (pAd->ApCfg.BssEdcaParm.Cwmax[i] << 4)           +     // b5-8 is CWMAX
								   (pAd->ApCfg.BssEdcaParm.Cwmin[i] & 0x0f);              // b0-3 is CWMIN
			WmeParmIe[12+ (i*4)] = (UCHAR)(pAd->ApCfg.BssEdcaParm.Txop[i] & 0xff);        // low byte of TXOP
			WmeParmIe[13+ (i*4)] = (UCHAR)(pAd->ApCfg.BssEdcaParm.Txop[i] >> 8);          // high byte of TXOP
		}

		MakeOutgoingFrame(pBeaconFrame+FrameLen,         &TmpLen,
						  26,                            WmeParmIe,
						  END_OF_ARGS);
		FrameLen += TmpLen;
	}
#endif
	DBGPRINT(RT_DEBUG_TRACE,("APMakeBssBeacon(len=%d)\n", FrameLen));
	//to be checked
	RTUSBWriteTxDescriptor(pAd, pTxD, CIPHER_NONE, 0, 0, FALSE, FALSE, TRUE, SHORT_RETRY, IFS_BACKOFF,
		pAd->CommonCfg.MlmeRate, FrameLen, QID_MGMT, 0,FALSE);
	pAd->ApCfg.TimIELocationInBeacon = (UCHAR)FrameLen;
	pAd->ApCfg.CapabilityInfoLocationInBeacon = sizeof(HEADER_802_11) + TIMESTAMP_LEN + 2;

}

/*
	==========================================================================
	Description:
		Update the BEACON frame in the shared memory. Because TIM IE is variable
		length. other IEs after TIM has to shift and total frame length may change
		for each BEACON period.
	Output:
		pAd->ApCfg.CapabilityInfo
		pAd->ApCfg.ErpIeContent
	==========================================================================
*/
VOID APUpdateBeaconFrame(
	IN PRTMP_ADAPTER pAd)
{
	PTXD_STRUC     pTxD = &pAd->BeaconTxD;
	PHEADER_802_11 pBcnHdr = (PHEADER_802_11)pAd->BeaconBuf;
	UCHAR  *ptr;
	ULONG FrameLen = pAd->ApCfg.TimIELocationInBeacon;
	UCHAR byte0 = (UCHAR)(pAd->ApCfg.TimBitmap & 0x000000fe);  // skip AID#0
	UCHAR byte1 = (UCHAR)((pAd->ApCfg.TimBitmap & 0x0000ff00) >> 8);
	UCHAR byte2 = (UCHAR)((pAd->ApCfg.TimBitmap & 0x00ff0000) >> 16);
	UCHAR byte3 = (UCHAR)((pAd->ApCfg.TimBitmap & 0xff000000) >> 24);
	UCHAR byte4 = (UCHAR)(pAd->ApCfg.TimBitmap2 & 0x000000ff);
	UCHAR byte5 = (UCHAR)((pAd->ApCfg.TimBitmap2 & 0x0000ff00) >> 8);
	UCHAR byte6 = (UCHAR)((pAd->ApCfg.TimBitmap2 & 0x00ff0000) >> 16);
	UCHAR byte7 = (UCHAR)((pAd->ApCfg.TimBitmap2 & 0xff000000) >> 24);
	UINT  i;
	unsigned long IrqFlags,IrqFlags2;

	//
	// step 1 - update BEACON's Capability
	//
	ptr = (UCHAR *)pBcnHdr + pAd->ApCfg.CapabilityInfoLocationInBeacon;
	*ptr = (UCHAR)(pAd->ApCfg.CapabilityInfo & 0x00ff);
	*(ptr+1) = (UCHAR)((pAd->ApCfg.CapabilityInfo & 0xff00) >> 8);

	//
	// step 2 - update TIM IE
	// TODO: enlarge TIM bitmap to support up to 64 STAs
	// TODO: re-measure if RT2600 TBTT interrupt happens faster than BEACON sent out time
	//
	if (pAd->ApCfg.DtimCount == 0)
		pAd->ApCfg.DtimCount = pAd->ApCfg.DtimPeriod - 1;
	else
		pAd->ApCfg.DtimCount -= 1;

	// fill EXTENDED RATE IE
	if (  (pAd->CommonCfg.PhyMode == PHY_11BG_MIXED) || ( pAd->CommonCfg.PhyMode == PHY_11G))
	{
		ptr = (UCHAR *)pBcnHdr + FrameLen; // pTxD->DataByteCnt;
    	*ptr = IE_ERP;
        *(ptr + 1) = 1;
        *(ptr + 2) = pAd->ApCfg.ErpIeContent;
		ptr      += 3;
		FrameLen += 3;
	}

//	ptr = (UCHAR *)pBcnHdr + pAd->ApCfg.TimIELocationInBeacon;
	ptr = (UCHAR *)pBcnHdr + FrameLen;
	*ptr = IE_TIM;
	*(ptr + 2) = pAd->ApCfg.DtimCount;
	*(ptr + 3) = pAd->ApCfg.DtimPeriod;

	if (byte0 || byte1) // there's some backlog frame for AID 1-15
	{
		*(ptr + 4) = 0;      // Virtual TIM bitmap stars from AID #0
		*(ptr + 5) = byte0;
		*(ptr + 6) = byte1;
		*(ptr + 7) = byte2;
		*(ptr + 8) = byte3;
		*(ptr + 9) = byte4;
		*(ptr + 10) = byte5;
		*(ptr + 11) = byte6;
		*(ptr + 12) = byte7;
		if (byte7)      *(ptr + 1) = 11; // IE length
		else if (byte6) *(ptr + 1) = 10; // IE length
		else if (byte5) *(ptr + 1) = 9;  // IE length
		else if (byte4) *(ptr + 1) = 8;  // IE length
		else if (byte3) *(ptr + 1) = 7;  // IE length
		else if (byte2) *(ptr + 1) = 6;  // IE length
		else if (byte1) *(ptr + 1) = 5;  // IE length
		else            *(ptr + 1) = 4;  // IE length
	}
	else if (byte2 || byte3) // there's some backlogged frame for AID 16-31
	{
		*(ptr + 4) = 2;      // Virtual TIM bitmap starts from AID #16
		*(ptr + 5) = byte2;
		*(ptr + 6) = byte3;
		*(ptr + 7) = byte4;
		*(ptr + 8) = byte5;
		*(ptr + 9) = byte6;
		*(ptr + 10) = byte7;
		if (byte7)      *(ptr + 1) = 9; // IE length
		else if (byte6) *(ptr + 1) = 8; // IE length
		else if (byte5) *(ptr + 1) = 7; // IE length
		else if (byte4) *(ptr + 1) = 6; // IE length
		else if (byte3) *(ptr + 1) = 5; // IE length
		else            *(ptr + 1) = 4; // IE length
	}
	else if (byte4 || byte5) // there's some backlogged frame for AID 32-47
	{
		*(ptr + 4) = 4;      // Virtual TIM bitmap starts from AID #32
		*(ptr + 5) = byte4;
		*(ptr + 6) = byte5;
		*(ptr + 7) = byte6;
		*(ptr + 8) = byte7;
		if (byte7)      *(ptr + 1) = 7; // IE length
		else if (byte6) *(ptr + 1) = 6; // IE length
		else if (byte5) *(ptr + 1) = 5; // IE length
		else            *(ptr + 1) = 4; // IE length
	}
	else if (byte6 || byte7) // there's some backlogged frame for AID 48-63
	{
		*(ptr + 4) = 6;      // Virtual TIM bitmap starts from AID #48
		*(ptr + 5) = byte6;
		*(ptr + 6) = byte7;
		if (byte7)      *(ptr + 1) = 5; // IE length
		else            *(ptr + 1) = 4; // IE length
	}
	else // no backlogged frames
	{
		*(ptr + 1) = 4; // IE length
		*(ptr + 4) = 0;
		*(ptr + 5) = 0;
	}

	// bit0 means backlogged mcast/bcast
	*(ptr + 4) |= (pAd->ApCfg.TimBitmap & 0x01);

	// adjust BEACON length according to the new TIM
	FrameLen += (2 + *(ptr+1));

	//
	// fill up Channel Switch Announcement Element
	//
	if ((pAd->CommonCfg.PhyMode == PHY_11A) && (pAd->CommonCfg.bIEEE80211H == 1) && (pAd->CommonCfg.RadarDetect.RDMode == RD_SWITCHING_MODE))
	{
		ptr = (UCHAR *)pBcnHdr + FrameLen;
		*ptr = IE_CHANNEL_SWITCH_ANNOUNCEMENT;
		*(ptr + 1) = 3;
		*(ptr + 2) = 1;
		*(ptr + 3) = pAd->CommonCfg.Channel;
		*(ptr + 4) = pAd->CommonCfg.RadarDetect.CSCount;
		ptr      += 5;
		FrameLen += 5;
	}
#if 0
	// fill EXTENDED RATE IE
	if (  (pAd->CommonCfg.PhyMode == PHY_11BG_MIXED) || ( pAd->CommonCfg.PhyMode == PHY_11G))
	{
		UCHAR ExtendedRatesLen;
		ExtendedRatesLen = pAd->CommonCfg.SupRateLen - 4;
		ptr = (UCHAR *)pBcnHdr + FrameLen; // pTxD->DataByteCnt;
        	*ptr = IE_ERP;
	        *(ptr + 1) = 1;
	        *(ptr + 2) = pAd->ApCfg.ErpIeContent;
		ptr      += 3;
		FrameLen += 3;
	}
#endif
	// add Ralink-specific IE here - Byte0.b0=1 for aggregation, Byte0.b1=1 for piggy-back
	if (pAd->CommonCfg.bAggregationCapable)
	{
		ULONG TmpLen;
		UCHAR RalinkSpecificIe[9] = {IE_VENDOR_SPECIFIC, 7, 0x00, 0x0c, 0x43, 0x01, 0x00, 0x00, 0x00};
		MakeOutgoingFrame((UCHAR *)pBcnHdr+FrameLen, &TmpLen,
						  9,                         RalinkSpecificIe,
						  END_OF_ARGS);
		FrameLen += TmpLen;

	}

	//
	// step 5. Since FrameLen may change, update TXD
	//
	DBGPRINT(RT_DEBUG_INFO, ("APUpdateBeaconFrame(len=%d)\n", FrameLen));
	DBGPRINT(RT_DEBUG_INFO, ("becaon mlmerate=%d\n", pAd->CommonCfg.MlmeRate));

	RTUSBWriteTxDescriptor(pAd, pTxD, CIPHER_NONE, 0, 0, FALSE, FALSE, TRUE, SHORT_RETRY, IFS_BACKOFF,
		pAd->CommonCfg.MlmeRate, FrameLen, QID_MGMT, 0,FALSE);

	//disable sync first
	AsicDisableSync(pAd);
	RTUSBWriteMACRegister(pAd, HW_BEACON_BASE0, 0); // invalidate BEACON0 owner/valid bit to prevent garbage
	RTUSBWriteMACRegister(pAd, HW_BEACON_BASE1, 0); // invalidate BEACON1 owner/valid bit to prevent garbage
	RTUSBWriteMACRegister(pAd, HW_BEACON_BASE2, 0); // invalidate BEACON2 owner/valid bit to prevent garbage
	RTUSBWriteMACRegister(pAd, HW_BEACON_BASE3, 0); // invalidate BEACON3 owner/valid bit to prevent garbage

	//
	// step 6. move BEACON TXD and frame content to on-chip memory
	//
	ptr = (PUCHAR)&pAd->BeaconTxD;
	for (i=0; i<TXINFO_SIZE; i+=4)  // 24-byte TXINFO field
	{
		//RTUSBWriteMACRegister(pAd, HW_BEACON_BASE0 + i, (ULONG)*ptr);
		RTUSBMultiWrite(pAd, HW_BEACON_BASE0 + i, ptr, 4);
		ptr += 4;
	}

	// update BEACON frame content. start right after the 24-byte TXINFO field
	ptr = pAd->BeaconBuf;
	for (i=0; i< pAd->BeaconTxD.DataByteCnt; i+=4)
	{
		//RTUSBWriteMACRegister(pAd, HW_BEACON_BASE0 + TXINFO_SIZE + i, (ULONG)*ptr);
		RTUSBMultiWrite(pAd, HW_BEACON_BASE0 + TXINFO_SIZE + i, ptr, 4);
		ptr += 4;
	}

	//
	// step 7 - if DTIM, then move backlogged bcast/mcast frames from PSQ to TXQ whenever DtimCount==0
#if 0
	// NOTE: This updated BEACON frame will be sent at "next" TBTT instead of at cureent TBTT. The reason is
	//       because ASIC already fetch the BEACON content down to TX FIFO before driver can make any
	//       modification. To compenstate this effect, the actual time to deilver PSQ frames will be
	//       at the time that we wrapping around DtimCount from 0 to DtimPeriod-1
	if ((pAd->ApCfg.DtimCount + 1) == pAd->ApCfg.DtimPeriod)
#else
	if (pAd->ApCfg.DtimCount == 0)
#endif
	{
		PQUEUE_ENTRY    pEntry;

		NdisAcquireSpinLock(&pAd->MacTabLock, IrqFlags);
		NdisAcquireSpinLock(&pAd->SendTxWaitQueueLock[QID_AC_BE], IrqFlags2);
		while (pAd->MacTab.McastPsQueue.Head)
		{
			pEntry = RemoveHeadQueue(&pAd->MacTab.McastPsQueue);
			InsertTailQueue(&pAd->SendTxWaitQueue[QID_AC_BE], pEntry);
			DBGPRINT(RT_DEBUG_TRACE, ("DTIM=%d/%d, tx mcast/bcast out...\n",pAd->ApCfg.DtimCount,pAd->ApCfg.DtimPeriod));
		}
		NdisReleaseSpinLock(&pAd->SendTxWaitQueueLock[QID_AC_BE], IrqFlags2);
		NdisReleaseSpinLock(&pAd->MacTabLock, IrqFlags);
		pAd->ApCfg.TimBitmap &= ~BIT32[0]; // clear MCAST/BCAST backlog bit
		pAd->MacTab.PsQIdleCount = 0;

		// Dequeue outgoing framea from TxSwQueue0..3 queue and process it
		RTMPDeQueuePacket(pAd,QID_AC_BE);
		RTUSBKickBulkOut(pAd);
	}
        //re-enable sync
	AsicEnableBssSync(pAd);
}


